/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummaryListCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnalyzableServersResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, ListAnalyzableServersResponse> {
    private static final SdkField<List<AnalyzableServerSummary>> ANALYZABLE_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analyzableServers").getter(ListAnalyzableServersResponse.getter(ListAnalyzableServersResponse::analyzableServers)).setter(ListAnalyzableServersResponse.setter(Builder::analyzableServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzableServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyzableServerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnalyzableServersResponse.getter(ListAnalyzableServersResponse::nextToken)).setter(ListAnalyzableServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZABLE_SERVERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("analyzableServers", ANALYZABLE_SERVERS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AnalyzableServerSummary> analyzableServers;
    private final String nextToken;

    private ListAnalyzableServersResponse(BuilderImpl builder) {
        super(builder);
        this.analyzableServers = builder.analyzableServers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnalyzableServers() {
        return this.analyzableServers != null && !(this.analyzableServers instanceof SdkAutoConstructList);
    }

    public final List<AnalyzableServerSummary> analyzableServers() {
        return this.analyzableServers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalyzableServers() ? this.analyzableServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalyzableServersResponse)) {
            return false;
        }
        ListAnalyzableServersResponse other = (ListAnalyzableServersResponse)((Object)obj);
        return this.hasAnalyzableServers() == other.hasAnalyzableServers() && Objects.equals(this.analyzableServers(), other.analyzableServers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnalyzableServersResponse").add("AnalyzableServers", this.hasAnalyzableServers() ? this.analyzableServers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzableServers": {
                return Optional.ofNullable(clazz.cast(this.analyzableServers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAnalyzableServersResponse, T> g) {
        return obj -> g.apply((ListAnalyzableServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<AnalyzableServerSummary> analyzableServers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalyzableServersResponse model) {
            super(model);
            this.analyzableServers(model.analyzableServers);
            this.nextToken(model.nextToken);
        }

        public final List<AnalyzableServerSummary.Builder> getAnalyzableServers() {
            List<AnalyzableServerSummary.Builder> result = AnalyzableServerSummaryListCopier.copyToBuilder(this.analyzableServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyzableServers(Collection<AnalyzableServerSummary.BuilderImpl> analyzableServers) {
            this.analyzableServers = AnalyzableServerSummaryListCopier.copyFromBuilder(analyzableServers);
        }

        @Override
        public final Builder analyzableServers(Collection<AnalyzableServerSummary> analyzableServers) {
            this.analyzableServers = AnalyzableServerSummaryListCopier.copy(analyzableServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzableServers(AnalyzableServerSummary ... analyzableServers) {
            this.analyzableServers(Arrays.asList(analyzableServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzableServers(Consumer<AnalyzableServerSummary.Builder> ... analyzableServers) {
            this.analyzableServers(Stream.of(analyzableServers).map(c -> (AnalyzableServerSummary)((AnalyzableServerSummary.Builder)AnalyzableServerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnalyzableServersResponse build() {
            return new ListAnalyzableServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnalyzableServersResponse> {
        public Builder analyzableServers(Collection<AnalyzableServerSummary> var1);

        public Builder analyzableServers(AnalyzableServerSummary ... var1);

        public Builder analyzableServers(Consumer<AnalyzableServerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

