/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssessmentDataSourceType {
    STRATEGY_RECOMMENDATIONS_APPLICATION_DATA_COLLECTOR("StrategyRecommendationsApplicationDataCollector"),
    MANUAL_IMPORT("ManualImport"),
    APPLICATION_DISCOVERY_SERVICE("ApplicationDiscoveryService"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssessmentDataSourceType> VALUE_MAP;
    private final String value;

    private AssessmentDataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssessmentDataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssessmentDataSourceType> knownValues() {
        EnumSet<AssessmentDataSourceType> knownValues = EnumSet.allOf(AssessmentDataSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssessmentDataSourceType.class, AssessmentDataSourceType::toString);
    }
}

