/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubstrategy.model.BinaryAnalyzerName;
import software.amazon.awssdk.services.migrationhubstrategy.model.RunTimeAnalyzerName;
import software.amazon.awssdk.services.migrationhubstrategy.model.SourceCodeAnalyzerName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzerNameUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyzerNameUnion> {
    private static final SdkField<String> BINARY_ANALYZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("binaryAnalyzerName").getter(AnalyzerNameUnion.getter(AnalyzerNameUnion::binaryAnalyzerNameAsString)).setter(AnalyzerNameUnion.setter(Builder::binaryAnalyzerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryAnalyzerName").build()}).build();
    private static final SdkField<String> RUN_TIME_ANALYZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runTimeAnalyzerName").getter(AnalyzerNameUnion.getter(AnalyzerNameUnion::runTimeAnalyzerNameAsString)).setter(AnalyzerNameUnion.setter(Builder::runTimeAnalyzerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runTimeAnalyzerName").build()}).build();
    private static final SdkField<String> SOURCE_CODE_ANALYZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCodeAnalyzerName").getter(AnalyzerNameUnion.getter(AnalyzerNameUnion::sourceCodeAnalyzerNameAsString)).setter(AnalyzerNameUnion.setter(Builder::sourceCodeAnalyzerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeAnalyzerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BINARY_ANALYZER_NAME_FIELD, RUN_TIME_ANALYZER_NAME_FIELD, SOURCE_CODE_ANALYZER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("binaryAnalyzerName", BINARY_ANALYZER_NAME_FIELD);
            this.put("runTimeAnalyzerName", RUN_TIME_ANALYZER_NAME_FIELD);
            this.put("sourceCodeAnalyzerName", SOURCE_CODE_ANALYZER_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String binaryAnalyzerName;
    private final String runTimeAnalyzerName;
    private final String sourceCodeAnalyzerName;
    private final Type type;

    private AnalyzerNameUnion(BuilderImpl builder) {
        this.binaryAnalyzerName = builder.binaryAnalyzerName;
        this.runTimeAnalyzerName = builder.runTimeAnalyzerName;
        this.sourceCodeAnalyzerName = builder.sourceCodeAnalyzerName;
        this.type = builder.type;
    }

    public final BinaryAnalyzerName binaryAnalyzerName() {
        return BinaryAnalyzerName.fromValue(this.binaryAnalyzerName);
    }

    public final String binaryAnalyzerNameAsString() {
        return this.binaryAnalyzerName;
    }

    public final RunTimeAnalyzerName runTimeAnalyzerName() {
        return RunTimeAnalyzerName.fromValue(this.runTimeAnalyzerName);
    }

    public final String runTimeAnalyzerNameAsString() {
        return this.runTimeAnalyzerName;
    }

    public final SourceCodeAnalyzerName sourceCodeAnalyzerName() {
        return SourceCodeAnalyzerName.fromValue(this.sourceCodeAnalyzerName);
    }

    public final String sourceCodeAnalyzerNameAsString() {
        return this.sourceCodeAnalyzerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryAnalyzerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runTimeAnalyzerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeAnalyzerNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzerNameUnion)) {
            return false;
        }
        AnalyzerNameUnion other = (AnalyzerNameUnion)obj;
        return Objects.equals(this.binaryAnalyzerNameAsString(), other.binaryAnalyzerNameAsString()) && Objects.equals(this.runTimeAnalyzerNameAsString(), other.runTimeAnalyzerNameAsString()) && Objects.equals(this.sourceCodeAnalyzerNameAsString(), other.sourceCodeAnalyzerNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzerNameUnion").add("BinaryAnalyzerName", (Object)this.binaryAnalyzerNameAsString()).add("RunTimeAnalyzerName", (Object)this.runTimeAnalyzerNameAsString()).add("SourceCodeAnalyzerName", (Object)this.sourceCodeAnalyzerNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "binaryAnalyzerName": {
                return Optional.ofNullable(clazz.cast(this.binaryAnalyzerNameAsString()));
            }
            case "runTimeAnalyzerName": {
                return Optional.ofNullable(clazz.cast(this.runTimeAnalyzerNameAsString()));
            }
            case "sourceCodeAnalyzerName": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeAnalyzerNameAsString()));
            }
        }
        return Optional.empty();
    }

    public static AnalyzerNameUnion fromBinaryAnalyzerName(String binaryAnalyzerName) {
        return (AnalyzerNameUnion)AnalyzerNameUnion.builder().binaryAnalyzerName(binaryAnalyzerName).build();
    }

    public static AnalyzerNameUnion fromBinaryAnalyzerName(BinaryAnalyzerName binaryAnalyzerName) {
        return (AnalyzerNameUnion)AnalyzerNameUnion.builder().binaryAnalyzerName(binaryAnalyzerName).build();
    }

    public static AnalyzerNameUnion fromRunTimeAnalyzerName(String runTimeAnalyzerName) {
        return (AnalyzerNameUnion)AnalyzerNameUnion.builder().runTimeAnalyzerName(runTimeAnalyzerName).build();
    }

    public static AnalyzerNameUnion fromRunTimeAnalyzerName(RunTimeAnalyzerName runTimeAnalyzerName) {
        return (AnalyzerNameUnion)AnalyzerNameUnion.builder().runTimeAnalyzerName(runTimeAnalyzerName).build();
    }

    public static AnalyzerNameUnion fromSourceCodeAnalyzerName(String sourceCodeAnalyzerName) {
        return (AnalyzerNameUnion)AnalyzerNameUnion.builder().sourceCodeAnalyzerName(sourceCodeAnalyzerName).build();
    }

    public static AnalyzerNameUnion fromSourceCodeAnalyzerName(SourceCodeAnalyzerName sourceCodeAnalyzerName) {
        return (AnalyzerNameUnion)AnalyzerNameUnion.builder().sourceCodeAnalyzerName(sourceCodeAnalyzerName).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzerNameUnion, T> g) {
        return obj -> g.apply((AnalyzerNameUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BINARY_ANALYZER_NAME,
        RUN_TIME_ANALYZER_NAME,
        SOURCE_CODE_ANALYZER_NAME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String binaryAnalyzerName;
        private String runTimeAnalyzerName;
        private String sourceCodeAnalyzerName;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzerNameUnion model) {
            this.binaryAnalyzerName(model.binaryAnalyzerName);
            this.runTimeAnalyzerName(model.runTimeAnalyzerName);
            this.sourceCodeAnalyzerName(model.sourceCodeAnalyzerName);
        }

        public final String getBinaryAnalyzerName() {
            return this.binaryAnalyzerName;
        }

        public final void setBinaryAnalyzerName(String binaryAnalyzerName) {
            String oldValue = this.binaryAnalyzerName;
            this.binaryAnalyzerName = binaryAnalyzerName;
            this.handleUnionValueChange(Type.BINARY_ANALYZER_NAME, oldValue, this.binaryAnalyzerName);
        }

        @Override
        public final Builder binaryAnalyzerName(String binaryAnalyzerName) {
            String oldValue = this.binaryAnalyzerName;
            this.binaryAnalyzerName = binaryAnalyzerName;
            this.handleUnionValueChange(Type.BINARY_ANALYZER_NAME, oldValue, this.binaryAnalyzerName);
            return this;
        }

        @Override
        public final Builder binaryAnalyzerName(BinaryAnalyzerName binaryAnalyzerName) {
            this.binaryAnalyzerName(binaryAnalyzerName == null ? null : binaryAnalyzerName.toString());
            return this;
        }

        public final String getRunTimeAnalyzerName() {
            return this.runTimeAnalyzerName;
        }

        public final void setRunTimeAnalyzerName(String runTimeAnalyzerName) {
            String oldValue = this.runTimeAnalyzerName;
            this.runTimeAnalyzerName = runTimeAnalyzerName;
            this.handleUnionValueChange(Type.RUN_TIME_ANALYZER_NAME, oldValue, this.runTimeAnalyzerName);
        }

        @Override
        public final Builder runTimeAnalyzerName(String runTimeAnalyzerName) {
            String oldValue = this.runTimeAnalyzerName;
            this.runTimeAnalyzerName = runTimeAnalyzerName;
            this.handleUnionValueChange(Type.RUN_TIME_ANALYZER_NAME, oldValue, this.runTimeAnalyzerName);
            return this;
        }

        @Override
        public final Builder runTimeAnalyzerName(RunTimeAnalyzerName runTimeAnalyzerName) {
            this.runTimeAnalyzerName(runTimeAnalyzerName == null ? null : runTimeAnalyzerName.toString());
            return this;
        }

        public final String getSourceCodeAnalyzerName() {
            return this.sourceCodeAnalyzerName;
        }

        public final void setSourceCodeAnalyzerName(String sourceCodeAnalyzerName) {
            String oldValue = this.sourceCodeAnalyzerName;
            this.sourceCodeAnalyzerName = sourceCodeAnalyzerName;
            this.handleUnionValueChange(Type.SOURCE_CODE_ANALYZER_NAME, oldValue, this.sourceCodeAnalyzerName);
        }

        @Override
        public final Builder sourceCodeAnalyzerName(String sourceCodeAnalyzerName) {
            String oldValue = this.sourceCodeAnalyzerName;
            this.sourceCodeAnalyzerName = sourceCodeAnalyzerName;
            this.handleUnionValueChange(Type.SOURCE_CODE_ANALYZER_NAME, oldValue, this.sourceCodeAnalyzerName);
            return this;
        }

        @Override
        public final Builder sourceCodeAnalyzerName(SourceCodeAnalyzerName sourceCodeAnalyzerName) {
            this.sourceCodeAnalyzerName(sourceCodeAnalyzerName == null ? null : sourceCodeAnalyzerName.toString());
            return this;
        }

        public AnalyzerNameUnion build() {
            return new AnalyzerNameUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyzerNameUnion> {
        public Builder binaryAnalyzerName(String var1);

        public Builder binaryAnalyzerName(BinaryAnalyzerName var1);

        public Builder runTimeAnalyzerName(String var1);

        public Builder runTimeAnalyzerName(RunTimeAnalyzerName var1);

        public Builder sourceCodeAnalyzerName(String var1);

        public Builder sourceCodeAnalyzerName(SourceCodeAnalyzerName var1);
    }
}

