/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesRequest;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ProxyType;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends MigrationHubRefactorSpacesRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<ApiGatewayProxyInput> API_GATEWAY_PROXY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiGatewayProxy").getter(CreateApplicationRequest.getter(CreateApplicationRequest::apiGatewayProxy)).setter(CreateApplicationRequest.setter(Builder::apiGatewayProxy)).constructor(ApiGatewayProxyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayProxy").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateApplicationRequest.getter(CreateApplicationRequest::clientToken)).setter(CreateApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentIdentifier").getter(CreateApplicationRequest.getter(CreateApplicationRequest::environmentIdentifier)).setter(CreateApplicationRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApplicationRequest.getter(CreateApplicationRequest::name)).setter(CreateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PROXY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxyType").getter(CreateApplicationRequest.getter(CreateApplicationRequest::proxyTypeAsString)).setter(CreateApplicationRequest.setter(Builder::proxyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateApplicationRequest.getter(CreateApplicationRequest::vpcId)).setter(CreateApplicationRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_PROXY_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PROXY_TYPE_FIELD, TAGS_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApiGatewayProxy", API_GATEWAY_PROXY_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("EnvironmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ProxyType", PROXY_TYPE_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
        }
    });
    private final ApiGatewayProxyInput apiGatewayProxy;
    private final String clientToken;
    private final String environmentIdentifier;
    private final String name;
    private final String proxyType;
    private final Map<String, String> tags;
    private final String vpcId;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.apiGatewayProxy = builder.apiGatewayProxy;
        this.clientToken = builder.clientToken;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.proxyType = builder.proxyType;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public final ApiGatewayProxyInput apiGatewayProxy() {
        return this.apiGatewayProxy;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final ProxyType proxyType() {
        return ProxyType.fromValue(this.proxyType);
    }

    public final String proxyTypeAsString() {
        return this.proxyType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayProxy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.apiGatewayProxy(), other.apiGatewayProxy()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.proxyTypeAsString(), other.proxyTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("ApiGatewayProxy", (Object)this.apiGatewayProxy()).add("ClientToken", (Object)this.clientToken()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("Name", (Object)this.name()).add("ProxyType", (Object)this.proxyTypeAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiGatewayProxy": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayProxy()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "EnvironmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ProxyType": {
                return Optional.ofNullable(clazz.cast(this.proxyTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubRefactorSpacesRequest.BuilderImpl
    implements Builder {
        private ApiGatewayProxyInput apiGatewayProxy;
        private String clientToken;
        private String environmentIdentifier;
        private String name;
        private String proxyType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.apiGatewayProxy(model.apiGatewayProxy);
            this.clientToken(model.clientToken);
            this.environmentIdentifier(model.environmentIdentifier);
            this.name(model.name);
            this.proxyType(model.proxyType);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final ApiGatewayProxyInput.Builder getApiGatewayProxy() {
            return this.apiGatewayProxy != null ? this.apiGatewayProxy.toBuilder() : null;
        }

        public final void setApiGatewayProxy(ApiGatewayProxyInput.BuilderImpl apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy != null ? apiGatewayProxy.build() : null;
        }

        @Override
        public final Builder apiGatewayProxy(ApiGatewayProxyInput apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProxyType() {
            return this.proxyType;
        }

        public final void setProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        public final Builder proxyType(String proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        @Override
        public final Builder proxyType(ProxyType proxyType) {
            this.proxyType(proxyType == null ? null : proxyType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubRefactorSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder apiGatewayProxy(ApiGatewayProxyInput var1);

        default public Builder apiGatewayProxy(Consumer<ApiGatewayProxyInput.Builder> apiGatewayProxy) {
            return this.apiGatewayProxy((ApiGatewayProxyInput)((ApiGatewayProxyInput.Builder)ApiGatewayProxyInput.builder().applyMutation(apiGatewayProxy)).build());
        }

        public Builder clientToken(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder name(String var1);

        public Builder proxyType(String var1);

        public Builder proxyType(ProxyType var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

