/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShardConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShardConfiguration> {
    private static final SdkField<String> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Slots").getter(ShardConfiguration.getter(ShardConfiguration::slots)).setter(ShardConfiguration.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slots").build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplicaCount").getter(ShardConfiguration.getter(ShardConfiguration::replicaCount)).setter(ShardConfiguration.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOTS_FIELD, REPLICA_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Slots", SLOTS_FIELD);
            this.put("ReplicaCount", REPLICA_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String slots;
    private final Integer replicaCount;

    private ShardConfiguration(BuilderImpl builder) {
        this.slots = builder.slots;
        this.replicaCount = builder.replicaCount;
    }

    public final String slots() {
        return this.slots;
    }

    public final Integer replicaCount() {
        return this.replicaCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardConfiguration)) {
            return false;
        }
        ShardConfiguration other = (ShardConfiguration)obj;
        return Objects.equals(this.slots(), other.slots()) && Objects.equals(this.replicaCount(), other.replicaCount());
    }

    public final String toString() {
        return ToString.builder((String)"ShardConfiguration").add("Slots", (Object)this.slots()).add("ReplicaCount", (Object)this.replicaCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "ReplicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ShardConfiguration, T> g) {
        return obj -> g.apply((ShardConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String slots;
        private Integer replicaCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardConfiguration model) {
            this.slots(model.slots);
            this.replicaCount(model.replicaCount);
        }

        public final String getSlots() {
            return this.slots;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public ShardConfiguration build() {
            return new ShardConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShardConfiguration> {
        public Builder slots(String var1);

        public Builder replicaCount(Integer var1);
    }
}

