/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.DatastoreStatus;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDatastoreResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, DeleteDatastoreResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(DeleteDatastoreResponse.getter(DeleteDatastoreResponse::datastoreId)).setter(DeleteDatastoreResponse.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()}).build();
    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreStatus").getter(DeleteDatastoreResponse.getter(DeleteDatastoreResponse::datastoreStatusAsString)).setter(DeleteDatastoreResponse.setter(Builder::datastoreStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, DATASTORE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datastoreId", DATASTORE_ID_FIELD);
            this.put("datastoreStatus", DATASTORE_STATUS_FIELD);
        }
    });
    private final String datastoreId;
    private final String datastoreStatus;

    private DeleteDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.datastoreStatus = builder.datastoreStatus;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(this.datastoreStatus);
    }

    public final String datastoreStatusAsString() {
        return this.datastoreStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDatastoreResponse)) {
            return false;
        }
        DeleteDatastoreResponse other = (DeleteDatastoreResponse)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.datastoreStatusAsString(), other.datastoreStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDatastoreResponse").add("DatastoreId", (Object)this.datastoreId()).add("DatastoreStatus", (Object)this.datastoreStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "datastoreStatus": {
                return Optional.ofNullable(clazz.cast(this.datastoreStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDatastoreResponse, T> g) {
        return obj -> g.apply((DeleteDatastoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String datastoreStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDatastoreResponse model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.datastoreStatus(model.datastoreStatus);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreStatus() {
            return this.datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        @Override
        public DeleteDatastoreResponse build() {
            return new DeleteDatastoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDatastoreResponse> {
        public Builder datastoreId(String var1);

        public Builder datastoreStatus(String var1);

        public Builder datastoreStatus(DatastoreStatus var1);
    }
}

