/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastore.model.ContainerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Container
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Container> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(Container.getter(Container::endpoint)).setter(Container.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Container.getter(Container::creationTime)).setter(Container.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(Container.getter(Container::arn)).setter(Container.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Container.getter(Container::name)).setter(Container.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Container.getter(Container::statusAsString)).setter(Container.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> ACCESS_LOGGING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccessLoggingEnabled").getter(Container.getter(Container::accessLoggingEnabled)).setter(Container.setter(Builder::accessLoggingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLoggingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, CREATION_TIME_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, ACCESS_LOGGING_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Endpoint", ENDPOINT_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ARN", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("AccessLoggingEnabled", ACCESS_LOGGING_ENABLED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final Instant creationTime;
    private final String arn;
    private final String name;
    private final String status;
    private final Boolean accessLoggingEnabled;

    private Container(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.creationTime = builder.creationTime;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.accessLoggingEnabled = builder.accessLoggingEnabled;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerStatus status() {
        return ContainerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean accessLoggingEnabled() {
        return this.accessLoggingEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLoggingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.accessLoggingEnabled(), other.accessLoggingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"Container").add("Endpoint", (Object)this.endpoint()).add("CreationTime", (Object)this.creationTime()).add("ARN", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("AccessLoggingEnabled", (Object)this.accessLoggingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AccessLoggingEnabled": {
                return Optional.ofNullable(clazz.cast(this.accessLoggingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private Instant creationTime;
        private String arn;
        private String name;
        private String status;
        private Boolean accessLoggingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.endpoint(model.endpoint);
            this.creationTime(model.creationTime);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.accessLoggingEnabled(model.accessLoggingEnabled);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getAccessLoggingEnabled() {
            return this.accessLoggingEnabled;
        }

        public final void setAccessLoggingEnabled(Boolean accessLoggingEnabled) {
            this.accessLoggingEnabled = accessLoggingEnabled;
        }

        @Override
        public final Builder accessLoggingEnabled(Boolean accessLoggingEnabled) {
            this.accessLoggingEnabled = accessLoggingEnabled;
            return this;
        }

        public Container build() {
            return new Container(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Container> {
        public Builder endpoint(String var1);

        public Builder creationTime(Instant var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ContainerStatus var1);

        public Builder accessLoggingEnabled(Boolean var1);
    }
}

