/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265QualityTuningLevel {
    SINGLE_PASS("SINGLE_PASS"),
    SINGLE_PASS_HQ("SINGLE_PASS_HQ"),
    MULTI_PASS_HQ("MULTI_PASS_HQ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265QualityTuningLevel> VALUE_MAP;
    private final String value;

    private H265QualityTuningLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265QualityTuningLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265QualityTuningLevel> knownValues() {
        EnumSet<H265QualityTuningLevel> knownValues = EnumSet.allOf(H265QualityTuningLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265QualityTuningLevel.class, H265QualityTuningLevel::toString);
    }
}

