/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.MessageDetail;
import software.amazon.awssdk.services.mediaconnect.model.TransportMediaInfo;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMessageDetailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowSourceMetadataResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, DescribeFlowSourceMetadataResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(DescribeFlowSourceMetadataResponse.getter(DescribeFlowSourceMetadataResponse::flowArn)).setter(DescribeFlowSourceMetadataResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<List<MessageDetail>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(DescribeFlowSourceMetadataResponse.getter(DescribeFlowSourceMetadataResponse::messages)).setter(DescribeFlowSourceMetadataResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(DescribeFlowSourceMetadataResponse.getter(DescribeFlowSourceMetadataResponse::timestamp)).setter(DescribeFlowSourceMetadataResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<TransportMediaInfo> TRANSPORT_MEDIA_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransportMediaInfo").getter(DescribeFlowSourceMetadataResponse.getter(DescribeFlowSourceMetadataResponse::transportMediaInfo)).setter(DescribeFlowSourceMetadataResponse.setter(Builder::transportMediaInfo)).constructor(TransportMediaInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportMediaInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, MESSAGES_FIELD, TIMESTAMP_FIELD, TRANSPORT_MEDIA_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("flowArn", FLOW_ARN_FIELD);
            this.put("messages", MESSAGES_FIELD);
            this.put("timestamp", TIMESTAMP_FIELD);
            this.put("transportMediaInfo", TRANSPORT_MEDIA_INFO_FIELD);
        }
    });
    private final String flowArn;
    private final List<MessageDetail> messages;
    private final Instant timestamp;
    private final TransportMediaInfo transportMediaInfo;

    private DescribeFlowSourceMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.messages = builder.messages;
        this.timestamp = builder.timestamp;
        this.transportMediaInfo = builder.transportMediaInfo;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<MessageDetail> messages() {
        return this.messages;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final TransportMediaInfo transportMediaInfo() {
        return this.transportMediaInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportMediaInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowSourceMetadataResponse)) {
            return false;
        }
        DescribeFlowSourceMetadataResponse other = (DescribeFlowSourceMetadataResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.transportMediaInfo(), other.transportMediaInfo());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFlowSourceMetadataResponse").add("FlowArn", (Object)this.flowArn()).add("Messages", this.hasMessages() ? this.messages() : null).add("Timestamp", (Object)this.timestamp()).add("TransportMediaInfo", (Object)this.transportMediaInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "TransportMediaInfo": {
                return Optional.ofNullable(clazz.cast(this.transportMediaInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowSourceMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFlowSourceMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<MessageDetail> messages = DefaultSdkAutoConstructList.getInstance();
        private Instant timestamp;
        private TransportMediaInfo transportMediaInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowSourceMetadataResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.messages(model.messages);
            this.timestamp(model.timestamp);
            this.transportMediaInfo(model.transportMediaInfo);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<MessageDetail.Builder> getMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<MessageDetail.BuilderImpl> messages) {
            this.messages = ___listOfMessageDetailCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<MessageDetail> messages) {
            this.messages = ___listOfMessageDetailCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(MessageDetail ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<MessageDetail.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (MessageDetail)((MessageDetail.Builder)MessageDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final TransportMediaInfo.Builder getTransportMediaInfo() {
            return this.transportMediaInfo != null ? this.transportMediaInfo.toBuilder() : null;
        }

        public final void setTransportMediaInfo(TransportMediaInfo.BuilderImpl transportMediaInfo) {
            this.transportMediaInfo = transportMediaInfo != null ? transportMediaInfo.build() : null;
        }

        @Override
        public final Builder transportMediaInfo(TransportMediaInfo transportMediaInfo) {
            this.transportMediaInfo = transportMediaInfo;
            return this;
        }

        @Override
        public DescribeFlowSourceMetadataResponse build() {
            return new DescribeFlowSourceMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFlowSourceMetadataResponse> {
        public Builder flowArn(String var1);

        public Builder messages(Collection<MessageDetail> var1);

        public Builder messages(MessageDetail ... var1);

        public Builder messages(Consumer<MessageDetail.Builder> ... var1);

        public Builder timestamp(Instant var1);

        public Builder transportMediaInfo(TransportMediaInfo var1);

        default public Builder transportMediaInfo(Consumer<TransportMediaInfo.Builder> transportMediaInfo) {
            return this.transportMediaInfo((TransportMediaInfo)((TransportMediaInfo.Builder)TransportMediaInfo.builder().applyMutation(transportMediaInfo)).build());
        }
    }
}

