/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceErrorsCopier;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceOutputItem;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceOutputListCopier;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTokenBalanceResponse
extends ManagedBlockchainQueryResponse
implements ToCopyableBuilder<Builder, BatchGetTokenBalanceResponse> {
    private static final SdkField<List<BatchGetTokenBalanceOutputItem>> TOKEN_BALANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tokenBalances").getter(BatchGetTokenBalanceResponse.getter(BatchGetTokenBalanceResponse::tokenBalances)).setter(BatchGetTokenBalanceResponse.setter(Builder::tokenBalances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenBalances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetTokenBalanceOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetTokenBalanceErrorItem>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetTokenBalanceResponse.getter(BatchGetTokenBalanceResponse::errors)).setter(BatchGetTokenBalanceResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetTokenBalanceErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_BALANCES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tokenBalances", TOKEN_BALANCES_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<BatchGetTokenBalanceOutputItem> tokenBalances;
    private final List<BatchGetTokenBalanceErrorItem> errors;

    private BatchGetTokenBalanceResponse(BuilderImpl builder) {
        super(builder);
        this.tokenBalances = builder.tokenBalances;
        this.errors = builder.errors;
    }

    public final boolean hasTokenBalances() {
        return this.tokenBalances != null && !(this.tokenBalances instanceof SdkAutoConstructList);
    }

    public final List<BatchGetTokenBalanceOutputItem> tokenBalances() {
        return this.tokenBalances;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetTokenBalanceErrorItem> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenBalances() ? this.tokenBalances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTokenBalanceResponse)) {
            return false;
        }
        BatchGetTokenBalanceResponse other = (BatchGetTokenBalanceResponse)((Object)obj);
        return this.hasTokenBalances() == other.hasTokenBalances() && Objects.equals(this.tokenBalances(), other.tokenBalances()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTokenBalanceResponse").add("TokenBalances", this.hasTokenBalances() ? this.tokenBalances() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenBalances": {
                return Optional.ofNullable(clazz.cast(this.tokenBalances()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTokenBalanceResponse, T> g) {
        return obj -> g.apply((BatchGetTokenBalanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryResponse.BuilderImpl
    implements Builder {
        private List<BatchGetTokenBalanceOutputItem> tokenBalances = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetTokenBalanceErrorItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTokenBalanceResponse model) {
            super(model);
            this.tokenBalances(model.tokenBalances);
            this.errors(model.errors);
        }

        public final List<BatchGetTokenBalanceOutputItem.Builder> getTokenBalances() {
            List<BatchGetTokenBalanceOutputItem.Builder> result = BatchGetTokenBalanceOutputListCopier.copyToBuilder(this.tokenBalances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTokenBalances(Collection<BatchGetTokenBalanceOutputItem.BuilderImpl> tokenBalances) {
            this.tokenBalances = BatchGetTokenBalanceOutputListCopier.copyFromBuilder(tokenBalances);
        }

        @Override
        public final Builder tokenBalances(Collection<BatchGetTokenBalanceOutputItem> tokenBalances) {
            this.tokenBalances = BatchGetTokenBalanceOutputListCopier.copy(tokenBalances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenBalances(BatchGetTokenBalanceOutputItem ... tokenBalances) {
            this.tokenBalances(Arrays.asList(tokenBalances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenBalances(Consumer<BatchGetTokenBalanceOutputItem.Builder> ... tokenBalances) {
            this.tokenBalances(Stream.of(tokenBalances).map(c -> (BatchGetTokenBalanceOutputItem)((BatchGetTokenBalanceOutputItem.Builder)BatchGetTokenBalanceOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetTokenBalanceErrorItem.Builder> getErrors() {
            List<BatchGetTokenBalanceErrorItem.Builder> result = BatchGetTokenBalanceErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetTokenBalanceErrorItem.BuilderImpl> errors) {
            this.errors = BatchGetTokenBalanceErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetTokenBalanceErrorItem> errors) {
            this.errors = BatchGetTokenBalanceErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetTokenBalanceErrorItem ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetTokenBalanceErrorItem.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetTokenBalanceErrorItem)((BatchGetTokenBalanceErrorItem.Builder)BatchGetTokenBalanceErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetTokenBalanceResponse build() {
            return new BatchGetTokenBalanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetTokenBalanceResponse> {
        public Builder tokenBalances(Collection<BatchGetTokenBalanceOutputItem> var1);

        public Builder tokenBalances(BatchGetTokenBalanceOutputItem ... var1);

        public Builder tokenBalances(Consumer<BatchGetTokenBalanceOutputItem.Builder> ... var1);

        public Builder errors(Collection<BatchGetTokenBalanceErrorItem> var1);

        public Builder errors(BatchGetTokenBalanceErrorItem ... var1);

        public Builder errors(Consumer<BatchGetTokenBalanceErrorItem.Builder> ... var1);
    }
}

