/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse;

public class ListNetworksIterable
implements SdkIterable<ListNetworksResponse> {
    private final ManagedBlockchainClient client;
    private final ListNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworksIterable(ManagedBlockchainClient client, ListNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNetworksResponseFetcher();
    }

    public Iterator<ListNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNetworksResponseFetcher
    implements SyncPageFetcher<ListNetworksResponse> {
        private ListNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworksResponse nextPage(ListNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListNetworksIterable.this.client.listNetworks(ListNetworksIterable.this.firstRequest);
            }
            return ListNetworksIterable.this.client.listNetworks((ListNetworksRequest)((Object)ListNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

