/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.Framework;
import software.amazon.awssdk.services.managedblockchain.model.NetworkStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(NetworkSummary.getter(NetworkSummary::id)).setter(NetworkSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(NetworkSummary.getter(NetworkSummary::name)).setter(NetworkSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(NetworkSummary.getter(NetworkSummary::description)).setter(NetworkSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Framework").getter(NetworkSummary.getter(NetworkSummary::frameworkAsString)).setter(NetworkSummary.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkVersion").getter(NetworkSummary.getter(NetworkSummary::frameworkVersion)).setter(NetworkSummary.setter(Builder::frameworkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NetworkSummary.getter(NetworkSummary::statusAsString)).setter(NetworkSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(NetworkSummary.getter(NetworkSummary::creationDate)).setter(NetworkSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(NetworkSummary.getter(NetworkSummary::arn)).setter(NetworkSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Framework", FRAMEWORK_FIELD);
            this.put("FrameworkVersion", FRAMEWORK_VERSION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
            this.put("Arn", ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String framework;
    private final String frameworkVersion;
    private final String status;
    private final Instant creationDate;
    private final String arn;

    private NetworkSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.arn = builder.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Framework framework() {
        return Framework.fromValue(this.framework);
    }

    public final String frameworkAsString() {
        return this.framework;
    }

    public final String frameworkVersion() {
        return this.frameworkVersion;
    }

    public final NetworkStatus status() {
        return NetworkStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSummary)) {
            return false;
        }
        NetworkSummary other = (NetworkSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.frameworkAsString(), other.frameworkAsString()) && Objects.equals(this.frameworkVersion(), other.frameworkVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Framework", (Object)this.frameworkAsString()).add("FrameworkVersion", (Object)this.frameworkVersion()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.frameworkAsString()));
            }
            case "FrameworkVersion": {
                return Optional.ofNullable(clazz.cast(this.frameworkVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkSummary, T> g) {
        return obj -> g.apply((NetworkSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String framework;
        private String frameworkVersion;
        private String status;
        private Instant creationDate;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.framework(model.framework);
            this.frameworkVersion(model.frameworkVersion);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.arn(model.arn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFramework() {
            return this.framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final String getFrameworkVersion() {
            return this.frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public NetworkSummary build() {
            return new NetworkSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder framework(String var1);

        public Builder framework(Framework var1);

        public Builder frameworkVersion(String var1);

        public Builder status(String var1);

        public Builder status(NetworkStatus var1);

        public Builder creationDate(Instant var1);

        public Builder arn(String var1);
    }
}

