/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.String20ListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PoAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PoAttributes> {
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encoding").getter(PoAttributes.getter(PoAttributes::encoding)).setter(PoAttributes.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(PoAttributes.getter(PoAttributes::format)).setter(PoAttributes.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<List<String>> MEMBER_FILE_EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberFileExtensions").getter(PoAttributes.getter(PoAttributes::memberFileExtensions)).setter(PoAttributes.setter(Builder::memberFileExtensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberFileExtensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_FIELD, FORMAT_FIELD, MEMBER_FILE_EXTENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("encoding", ENCODING_FIELD);
            this.put("format", FORMAT_FIELD);
            this.put("memberFileExtensions", MEMBER_FILE_EXTENSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String encoding;
    private final String format;
    private final List<String> memberFileExtensions;

    private PoAttributes(BuilderImpl builder) {
        this.encoding = builder.encoding;
        this.format = builder.format;
        this.memberFileExtensions = builder.memberFileExtensions;
    }

    public final String encoding() {
        return this.encoding;
    }

    public final String format() {
        return this.format;
    }

    public final boolean hasMemberFileExtensions() {
        return this.memberFileExtensions != null && !(this.memberFileExtensions instanceof SdkAutoConstructList);
    }

    public final List<String> memberFileExtensions() {
        return this.memberFileExtensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberFileExtensions() ? this.memberFileExtensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoAttributes)) {
            return false;
        }
        PoAttributes other = (PoAttributes)obj;
        return Objects.equals(this.encoding(), other.encoding()) && Objects.equals(this.format(), other.format()) && this.hasMemberFileExtensions() == other.hasMemberFileExtensions() && Objects.equals(this.memberFileExtensions(), other.memberFileExtensions());
    }

    public final String toString() {
        return ToString.builder((String)"PoAttributes").add("Encoding", (Object)this.encoding()).add("Format", (Object)this.format()).add("MemberFileExtensions", this.hasMemberFileExtensions() ? this.memberFileExtensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encoding": {
                return Optional.ofNullable(clazz.cast(this.encoding()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "memberFileExtensions": {
                return Optional.ofNullable(clazz.cast(this.memberFileExtensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PoAttributes, T> g) {
        return obj -> g.apply((PoAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encoding;
        private String format;
        private List<String> memberFileExtensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PoAttributes model) {
            this.encoding(model.encoding);
            this.format(model.format);
            this.memberFileExtensions(model.memberFileExtensions);
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final Collection<String> getMemberFileExtensions() {
            if (this.memberFileExtensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberFileExtensions;
        }

        public final void setMemberFileExtensions(Collection<String> memberFileExtensions) {
            this.memberFileExtensions = String20ListCopier.copy(memberFileExtensions);
        }

        @Override
        public final Builder memberFileExtensions(Collection<String> memberFileExtensions) {
            this.memberFileExtensions = String20ListCopier.copy(memberFileExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberFileExtensions(String ... memberFileExtensions) {
            this.memberFileExtensions(Arrays.asList(memberFileExtensions));
            return this;
        }

        public PoAttributes build() {
            return new PoAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PoAttributes> {
        public Builder encoding(String var1);

        public Builder format(String var1);

        public Builder memberFileExtensions(Collection<String> var1);

        public Builder memberFileExtensions(String ... var1);
    }
}

