/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentLifecycle {
    DEPLOYING("Deploying"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    UPDATING_DEPLOYMENT("Updating Deployment"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentLifecycle> VALUE_MAP;
    private final String value;

    private DeploymentLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentLifecycle> knownValues() {
        EnumSet<DeploymentLifecycle> knownValues = EnumSet.allOf(DeploymentLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentLifecycle.class, DeploymentLifecycle::toString);
    }
}

