/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelStatus {
    TRAINING("TRAINING"),
    TRAINED("TRAINED"),
    TRAINING_FAILED("TRAINING_FAILED"),
    STARTING_HOSTING("STARTING_HOSTING"),
    HOSTED("HOSTED"),
    HOSTING_FAILED("HOSTING_FAILED"),
    STOPPING_HOSTING("STOPPING_HOSTING"),
    SYSTEM_UPDATING("SYSTEM_UPDATING"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelStatus> VALUE_MAP;
    private final String value;

    private ModelStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelStatus> knownValues() {
        EnumSet<ModelStatus> knownValues = EnumSet.allOf(ModelStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelStatus.class, ModelStatus::toString);
    }
}

