/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.Action;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertFilters;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAlertRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, UpdateAlertRequest> {
    private static final SdkField<String> ALERT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertArn").getter(UpdateAlertRequest.getter(UpdateAlertRequest::alertArn)).setter(UpdateAlertRequest.setter(Builder::alertArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertArn").build()}).build();
    private static final SdkField<String> ALERT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertDescription").getter(UpdateAlertRequest.getter(UpdateAlertRequest::alertDescription)).setter(UpdateAlertRequest.setter(Builder::alertDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertDescription").build()}).build();
    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AlertSensitivityThreshold").getter(UpdateAlertRequest.getter(UpdateAlertRequest::alertSensitivityThreshold)).setter(UpdateAlertRequest.setter(Builder::alertSensitivityThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build()}).build();
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(UpdateAlertRequest.getter(UpdateAlertRequest::action)).setter(UpdateAlertRequest.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<AlertFilters> ALERT_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlertFilters").getter(UpdateAlertRequest.getter(UpdateAlertRequest::alertFilters)).setter(UpdateAlertRequest.setter(Builder::alertFilters)).constructor(AlertFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertFilters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_ARN_FIELD, ALERT_DESCRIPTION_FIELD, ALERT_SENSITIVITY_THRESHOLD_FIELD, ACTION_FIELD, ALERT_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AlertArn", ALERT_ARN_FIELD);
            this.put("AlertDescription", ALERT_DESCRIPTION_FIELD);
            this.put("AlertSensitivityThreshold", ALERT_SENSITIVITY_THRESHOLD_FIELD);
            this.put("Action", ACTION_FIELD);
            this.put("AlertFilters", ALERT_FILTERS_FIELD);
        }
    });
    private final String alertArn;
    private final String alertDescription;
    private final Integer alertSensitivityThreshold;
    private final Action action;
    private final AlertFilters alertFilters;

    private UpdateAlertRequest(BuilderImpl builder) {
        super(builder);
        this.alertArn = builder.alertArn;
        this.alertDescription = builder.alertDescription;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.action = builder.action;
        this.alertFilters = builder.alertFilters;
    }

    public final String alertArn() {
        return this.alertArn;
    }

    public final String alertDescription() {
        return this.alertDescription;
    }

    public final Integer alertSensitivityThreshold() {
        return this.alertSensitivityThreshold;
    }

    public final Action action() {
        return this.action;
    }

    public final AlertFilters alertFilters() {
        return this.alertFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alertArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertFilters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAlertRequest)) {
            return false;
        }
        UpdateAlertRequest other = (UpdateAlertRequest)((Object)obj);
        return Objects.equals(this.alertArn(), other.alertArn()) && Objects.equals(this.alertDescription(), other.alertDescription()) && Objects.equals(this.alertSensitivityThreshold(), other.alertSensitivityThreshold()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.alertFilters(), other.alertFilters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAlertRequest").add("AlertArn", (Object)this.alertArn()).add("AlertDescription", (Object)this.alertDescription()).add("AlertSensitivityThreshold", (Object)this.alertSensitivityThreshold()).add("Action", (Object)this.action()).add("AlertFilters", (Object)this.alertFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlertArn": {
                return Optional.ofNullable(clazz.cast(this.alertArn()));
            }
            case "AlertDescription": {
                return Optional.ofNullable(clazz.cast(this.alertDescription()));
            }
            case "AlertSensitivityThreshold": {
                return Optional.ofNullable(clazz.cast(this.alertSensitivityThreshold()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "AlertFilters": {
                return Optional.ofNullable(clazz.cast(this.alertFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAlertRequest, T> g) {
        return obj -> g.apply((UpdateAlertRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String alertArn;
        private String alertDescription;
        private Integer alertSensitivityThreshold;
        private Action action;
        private AlertFilters alertFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAlertRequest model) {
            super(model);
            this.alertArn(model.alertArn);
            this.alertDescription(model.alertDescription);
            this.alertSensitivityThreshold(model.alertSensitivityThreshold);
            this.action(model.action);
            this.alertFilters(model.alertFilters);
        }

        public final String getAlertArn() {
            return this.alertArn;
        }

        public final void setAlertArn(String alertArn) {
            this.alertArn = alertArn;
        }

        @Override
        public final Builder alertArn(String alertArn) {
            this.alertArn = alertArn;
            return this;
        }

        public final String getAlertDescription() {
            return this.alertDescription;
        }

        public final void setAlertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
        }

        @Override
        public final Builder alertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
            return this;
        }

        public final Integer getAlertSensitivityThreshold() {
            return this.alertSensitivityThreshold;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final AlertFilters.Builder getAlertFilters() {
            return this.alertFilters != null ? this.alertFilters.toBuilder() : null;
        }

        public final void setAlertFilters(AlertFilters.BuilderImpl alertFilters) {
            this.alertFilters = alertFilters != null ? alertFilters.build() : null;
        }

        @Override
        public final Builder alertFilters(AlertFilters alertFilters) {
            this.alertFilters = alertFilters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAlertRequest build() {
            return new UpdateAlertRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAlertRequest> {
        public Builder alertArn(String var1);

        public Builder alertDescription(String var1);

        public Builder alertSensitivityThreshold(Integer var1);

        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder alertFilters(AlertFilters var1);

        default public Builder alertFilters(Consumer<AlertFilters.Builder> alertFilters) {
            return this.alertFilters((AlertFilters)((AlertFilters.Builder)AlertFilters.builder().applyMutation(alertFilters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

