/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.StatisticalIssueStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LargeTimestampGaps
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LargeTimestampGaps> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LargeTimestampGaps.getter(LargeTimestampGaps::statusAsString)).setter(LargeTimestampGaps.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_LARGE_TIMESTAMP_GAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfLargeTimestampGaps").getter(LargeTimestampGaps.getter(LargeTimestampGaps::numberOfLargeTimestampGaps)).setter(LargeTimestampGaps.setter(Builder::numberOfLargeTimestampGaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLargeTimestampGaps").build()}).build();
    private static final SdkField<Integer> MAX_TIMESTAMP_GAP_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxTimestampGapInDays").getter(LargeTimestampGaps.getter(LargeTimestampGaps::maxTimestampGapInDays)).setter(LargeTimestampGaps.setter(Builder::maxTimestampGapInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTimestampGapInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NUMBER_OF_LARGE_TIMESTAMP_GAPS_FIELD, MAX_TIMESTAMP_GAP_IN_DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("NumberOfLargeTimestampGaps", NUMBER_OF_LARGE_TIMESTAMP_GAPS_FIELD);
            this.put("MaxTimestampGapInDays", MAX_TIMESTAMP_GAP_IN_DAYS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Integer numberOfLargeTimestampGaps;
    private final Integer maxTimestampGapInDays;

    private LargeTimestampGaps(BuilderImpl builder) {
        this.status = builder.status;
        this.numberOfLargeTimestampGaps = builder.numberOfLargeTimestampGaps;
        this.maxTimestampGapInDays = builder.maxTimestampGapInDays;
    }

    public final StatisticalIssueStatus status() {
        return StatisticalIssueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer numberOfLargeTimestampGaps() {
        return this.numberOfLargeTimestampGaps;
    }

    public final Integer maxTimestampGapInDays() {
        return this.maxTimestampGapInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLargeTimestampGaps());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTimestampGapInDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LargeTimestampGaps)) {
            return false;
        }
        LargeTimestampGaps other = (LargeTimestampGaps)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.numberOfLargeTimestampGaps(), other.numberOfLargeTimestampGaps()) && Objects.equals(this.maxTimestampGapInDays(), other.maxTimestampGapInDays());
    }

    public final String toString() {
        return ToString.builder((String)"LargeTimestampGaps").add("Status", (Object)this.statusAsString()).add("NumberOfLargeTimestampGaps", (Object)this.numberOfLargeTimestampGaps()).add("MaxTimestampGapInDays", (Object)this.maxTimestampGapInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NumberOfLargeTimestampGaps": {
                return Optional.ofNullable(clazz.cast(this.numberOfLargeTimestampGaps()));
            }
            case "MaxTimestampGapInDays": {
                return Optional.ofNullable(clazz.cast(this.maxTimestampGapInDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LargeTimestampGaps, T> g) {
        return obj -> g.apply((LargeTimestampGaps)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Integer numberOfLargeTimestampGaps;
        private Integer maxTimestampGapInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(LargeTimestampGaps model) {
            this.status(model.status);
            this.numberOfLargeTimestampGaps(model.numberOfLargeTimestampGaps);
            this.maxTimestampGapInDays(model.maxTimestampGapInDays);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatisticalIssueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getNumberOfLargeTimestampGaps() {
            return this.numberOfLargeTimestampGaps;
        }

        public final void setNumberOfLargeTimestampGaps(Integer numberOfLargeTimestampGaps) {
            this.numberOfLargeTimestampGaps = numberOfLargeTimestampGaps;
        }

        @Override
        public final Builder numberOfLargeTimestampGaps(Integer numberOfLargeTimestampGaps) {
            this.numberOfLargeTimestampGaps = numberOfLargeTimestampGaps;
            return this;
        }

        public final Integer getMaxTimestampGapInDays() {
            return this.maxTimestampGapInDays;
        }

        public final void setMaxTimestampGapInDays(Integer maxTimestampGapInDays) {
            this.maxTimestampGapInDays = maxTimestampGapInDays;
        }

        @Override
        public final Builder maxTimestampGapInDays(Integer maxTimestampGapInDays) {
            this.maxTimestampGapInDays = maxTimestampGapInDays;
            return this;
        }

        public LargeTimestampGaps build() {
            return new LargeTimestampGaps(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LargeTimestampGaps> {
        public Builder status(String var1);

        public Builder status(StatisticalIssueStatus var1);

        public Builder numberOfLargeTimestampGaps(Integer var1);

        public Builder maxTimestampGapInDays(Integer var1);
    }
}

