/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ModelPromoteMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRetrainingSchedulerRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, CreateRetrainingSchedulerRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(CreateRetrainingSchedulerRequest.getter(CreateRetrainingSchedulerRequest::modelName)).setter(CreateRetrainingSchedulerRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Instant> RETRAINING_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RetrainingStartDate").getter(CreateRetrainingSchedulerRequest.getter(CreateRetrainingSchedulerRequest::retrainingStartDate)).setter(CreateRetrainingSchedulerRequest.setter(Builder::retrainingStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingStartDate").build()}).build();
    private static final SdkField<String> RETRAINING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrainingFrequency").getter(CreateRetrainingSchedulerRequest.getter(CreateRetrainingSchedulerRequest::retrainingFrequency)).setter(CreateRetrainingSchedulerRequest.setter(Builder::retrainingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingFrequency").build()}).build();
    private static final SdkField<String> LOOKBACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackWindow").getter(CreateRetrainingSchedulerRequest.getter(CreateRetrainingSchedulerRequest::lookbackWindow)).setter(CreateRetrainingSchedulerRequest.setter(Builder::lookbackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()}).build();
    private static final SdkField<String> PROMOTE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromoteMode").getter(CreateRetrainingSchedulerRequest.getter(CreateRetrainingSchedulerRequest::promoteModeAsString)).setter(CreateRetrainingSchedulerRequest.setter(Builder::promoteMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromoteMode").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRetrainingSchedulerRequest.getter(CreateRetrainingSchedulerRequest::clientToken)).setter(CreateRetrainingSchedulerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, RETRAINING_START_DATE_FIELD, RETRAINING_FREQUENCY_FIELD, LOOKBACK_WINDOW_FIELD, PROMOTE_MODE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelName", MODEL_NAME_FIELD);
            this.put("RetrainingStartDate", RETRAINING_START_DATE_FIELD);
            this.put("RetrainingFrequency", RETRAINING_FREQUENCY_FIELD);
            this.put("LookbackWindow", LOOKBACK_WINDOW_FIELD);
            this.put("PromoteMode", PROMOTE_MODE_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String modelName;
    private final Instant retrainingStartDate;
    private final String retrainingFrequency;
    private final String lookbackWindow;
    private final String promoteMode;
    private final String clientToken;

    private CreateRetrainingSchedulerRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.retrainingStartDate = builder.retrainingStartDate;
        this.retrainingFrequency = builder.retrainingFrequency;
        this.lookbackWindow = builder.lookbackWindow;
        this.promoteMode = builder.promoteMode;
        this.clientToken = builder.clientToken;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final Instant retrainingStartDate() {
        return this.retrainingStartDate;
    }

    public final String retrainingFrequency() {
        return this.retrainingFrequency;
    }

    public final String lookbackWindow() {
        return this.lookbackWindow;
    }

    public final ModelPromoteMode promoteMode() {
        return ModelPromoteMode.fromValue(this.promoteMode);
    }

    public final String promoteModeAsString() {
        return this.promoteMode;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.promoteModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRetrainingSchedulerRequest)) {
            return false;
        }
        CreateRetrainingSchedulerRequest other = (CreateRetrainingSchedulerRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.retrainingStartDate(), other.retrainingStartDate()) && Objects.equals(this.retrainingFrequency(), other.retrainingFrequency()) && Objects.equals(this.lookbackWindow(), other.lookbackWindow()) && Objects.equals(this.promoteModeAsString(), other.promoteModeAsString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRetrainingSchedulerRequest").add("ModelName", (Object)this.modelName()).add("RetrainingStartDate", (Object)this.retrainingStartDate()).add("RetrainingFrequency", (Object)this.retrainingFrequency()).add("LookbackWindow", (Object)this.lookbackWindow()).add("PromoteMode", (Object)this.promoteModeAsString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "RetrainingStartDate": {
                return Optional.ofNullable(clazz.cast(this.retrainingStartDate()));
            }
            case "RetrainingFrequency": {
                return Optional.ofNullable(clazz.cast(this.retrainingFrequency()));
            }
            case "LookbackWindow": {
                return Optional.ofNullable(clazz.cast(this.lookbackWindow()));
            }
            case "PromoteMode": {
                return Optional.ofNullable(clazz.cast(this.promoteModeAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRetrainingSchedulerRequest, T> g) {
        return obj -> g.apply((CreateRetrainingSchedulerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private Instant retrainingStartDate;
        private String retrainingFrequency;
        private String lookbackWindow;
        private String promoteMode;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRetrainingSchedulerRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.retrainingStartDate(model.retrainingStartDate);
            this.retrainingFrequency(model.retrainingFrequency);
            this.lookbackWindow(model.lookbackWindow);
            this.promoteMode(model.promoteMode);
            this.clientToken(model.clientToken);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Instant getRetrainingStartDate() {
            return this.retrainingStartDate;
        }

        public final void setRetrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
        }

        @Override
        public final Builder retrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
            return this;
        }

        public final String getRetrainingFrequency() {
            return this.retrainingFrequency;
        }

        public final void setRetrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
        }

        @Override
        public final Builder retrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
            return this;
        }

        public final String getLookbackWindow() {
            return this.lookbackWindow;
        }

        public final void setLookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
        }

        @Override
        public final Builder lookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        public final String getPromoteMode() {
            return this.promoteMode;
        }

        public final void setPromoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
        }

        @Override
        public final Builder promoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
            return this;
        }

        @Override
        public final Builder promoteMode(ModelPromoteMode promoteMode) {
            this.promoteMode(promoteMode == null ? null : promoteMode.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRetrainingSchedulerRequest build() {
            return new CreateRetrainingSchedulerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRetrainingSchedulerRequest> {
        public Builder modelName(String var1);

        public Builder retrainingStartDate(Instant var1);

        public Builder retrainingFrequency(String var1);

        public Builder lookbackWindow(String var1);

        public Builder promoteMode(String var1);

        public Builder promoteMode(ModelPromoteMode var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

