/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.DataUploadFrequency;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.Tag;
import software.amazon.awssdk.services.lookoutequipment.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceSchedulerRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, CreateInferenceSchedulerRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::modelName)).setter(CreateInferenceSchedulerRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::inferenceSchedulerName)).setter(CreateInferenceSchedulerRequest.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataDelayOffsetInMinutes").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::dataDelayOffsetInMinutes)).setter(CreateInferenceSchedulerRequest.setter(Builder::dataDelayOffsetInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build()}).build();
    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataUploadFrequency").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::dataUploadFrequencyAsString)).setter(CreateInferenceSchedulerRequest.setter(Builder::dataUploadFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build()}).build();
    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataInputConfiguration").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::dataInputConfiguration)).setter(CreateInferenceSchedulerRequest.setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataOutputConfiguration").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::dataOutputConfiguration)).setter(CreateInferenceSchedulerRequest.setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::roleArn)).setter(CreateInferenceSchedulerRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::serverSideKmsKeyId)).setter(CreateInferenceSchedulerRequest.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::clientToken)).setter(CreateInferenceSchedulerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateInferenceSchedulerRequest.getter(CreateInferenceSchedulerRequest::tags)).setter(CreateInferenceSchedulerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD, DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelName", MODEL_NAME_FIELD);
            this.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
            this.put("DataDelayOffsetInMinutes", DATA_DELAY_OFFSET_IN_MINUTES_FIELD);
            this.put("DataUploadFrequency", DATA_UPLOAD_FREQUENCY_FIELD);
            this.put("DataInputConfiguration", DATA_INPUT_CONFIGURATION_FIELD);
            this.put("DataOutputConfiguration", DATA_OUTPUT_CONFIGURATION_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("ServerSideKmsKeyId", SERVER_SIDE_KMS_KEY_ID_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String modelName;
    private final String inferenceSchedulerName;
    private final Long dataDelayOffsetInMinutes;
    private final String dataUploadFrequency;
    private final InferenceInputConfiguration dataInputConfiguration;
    private final InferenceOutputConfiguration dataOutputConfiguration;
    private final String roleArn;
    private final String serverSideKmsKeyId;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateInferenceSchedulerRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.roleArn = builder.roleArn;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final Long dataDelayOffsetInMinutes() {
        return this.dataDelayOffsetInMinutes;
    }

    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(this.dataUploadFrequency);
    }

    public final String dataUploadFrequencyAsString() {
        return this.dataUploadFrequency;
    }

    public final InferenceInputConfiguration dataInputConfiguration() {
        return this.dataInputConfiguration;
    }

    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return this.dataOutputConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceSchedulerRequest)) {
            return false;
        }
        CreateInferenceSchedulerRequest other = (CreateInferenceSchedulerRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes()) && Objects.equals(this.dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString()) && Objects.equals(this.dataInputConfiguration(), other.dataInputConfiguration()) && Objects.equals(this.dataOutputConfiguration(), other.dataOutputConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceSchedulerRequest").add("ModelName", (Object)this.modelName()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("DataDelayOffsetInMinutes", (Object)this.dataDelayOffsetInMinutes()).add("DataUploadFrequency", (Object)this.dataUploadFrequencyAsString()).add("DataInputConfiguration", (Object)this.dataInputConfiguration()).add("DataOutputConfiguration", (Object)this.dataOutputConfiguration()).add("RoleArn", (Object)this.roleArn()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "DataDelayOffsetInMinutes": {
                return Optional.ofNullable(clazz.cast(this.dataDelayOffsetInMinutes()));
            }
            case "DataUploadFrequency": {
                return Optional.ofNullable(clazz.cast(this.dataUploadFrequencyAsString()));
            }
            case "DataInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataInputConfiguration()));
            }
            case "DataOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataOutputConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceSchedulerRequest, T> g) {
        return obj -> g.apply((CreateInferenceSchedulerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private String inferenceSchedulerName;
        private Long dataDelayOffsetInMinutes;
        private String dataUploadFrequency;
        private InferenceInputConfiguration dataInputConfiguration;
        private InferenceOutputConfiguration dataOutputConfiguration;
        private String roleArn;
        private String serverSideKmsKeyId;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceSchedulerRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            this.dataUploadFrequency(model.dataUploadFrequency);
            this.dataInputConfiguration(model.dataInputConfiguration);
            this.dataOutputConfiguration(model.dataOutputConfiguration);
            this.roleArn(model.roleArn);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return this.dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return this.dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return this.dataInputConfiguration != null ? this.dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return this.dataOutputConfiguration != null ? this.dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceSchedulerRequest build() {
            return new CreateInferenceSchedulerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceSchedulerRequest> {
        public Builder modelName(String var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder dataDelayOffsetInMinutes(Long var1);

        public Builder dataUploadFrequency(String var1);

        public Builder dataUploadFrequency(DataUploadFrequency var1);

        public Builder dataInputConfiguration(InferenceInputConfiguration var1);

        default public Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return this.dataInputConfiguration((InferenceInputConfiguration)((InferenceInputConfiguration.Builder)InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration)).build());
        }

        public Builder dataOutputConfiguration(InferenceOutputConfiguration var1);

        default public Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return this.dataOutputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder serverSideKmsKeyId(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

