/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Step
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Step> {
    private static final SdkField<List<Double>> START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StartPosition").getter(Step.getter(Step::startPosition)).setter(Step.setter(Builder::startPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> END_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndPosition").getter(Step.getter(Step::endPosition)).setter(Step.setter(Builder::endPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Distance").getter(Step.getter(Step::distance)).setter(Step.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Double> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DurationSeconds").getter(Step.getter(Step::durationSeconds)).setter(Step.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(Step.getter(Step::geometryOffset)).setter(Step.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_POSITION_FIELD, END_POSITION_FIELD, DISTANCE_FIELD, DURATION_SECONDS_FIELD, GEOMETRY_OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StartPosition", START_POSITION_FIELD);
            this.put("EndPosition", END_POSITION_FIELD);
            this.put("Distance", DISTANCE_FIELD);
            this.put("DurationSeconds", DURATION_SECONDS_FIELD);
            this.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Double> startPosition;
    private final List<Double> endPosition;
    private final Double distance;
    private final Double durationSeconds;
    private final Integer geometryOffset;

    private Step(BuilderImpl builder) {
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
        this.distance = builder.distance;
        this.durationSeconds = builder.durationSeconds;
        this.geometryOffset = builder.geometryOffset;
    }

    public final boolean hasStartPosition() {
        return this.startPosition != null && !(this.startPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> startPosition() {
        return this.startPosition;
    }

    public final boolean hasEndPosition() {
        return this.endPosition != null && !(this.endPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> endPosition() {
        return this.endPosition;
    }

    public final Double distance() {
        return this.distance;
    }

    public final Double durationSeconds() {
        return this.durationSeconds;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartPosition() ? this.startPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndPosition() ? this.endPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step)obj;
        return this.hasStartPosition() == other.hasStartPosition() && Objects.equals(this.startPosition(), other.startPosition()) && this.hasEndPosition() == other.hasEndPosition() && Objects.equals(this.endPosition(), other.endPosition()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.geometryOffset(), other.geometryOffset());
    }

    public final String toString() {
        return ToString.builder((String)"Step").add("StartPosition", (Object)(this.startPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("EndPosition", (Object)(this.endPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("Distance", (Object)this.distance()).add("DurationSeconds", (Object)this.durationSeconds()).add("GeometryOffset", (Object)this.geometryOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartPosition": {
                return Optional.ofNullable(clazz.cast(this.startPosition()));
            }
            case "EndPosition": {
                return Optional.ofNullable(clazz.cast(this.endPosition()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> startPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> endPosition = DefaultSdkAutoConstructList.getInstance();
        private Double distance;
        private Double durationSeconds;
        private Integer geometryOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            this.startPosition(model.startPosition);
            this.endPosition(model.endPosition);
            this.distance(model.distance);
            this.durationSeconds(model.durationSeconds);
            this.geometryOffset(model.geometryOffset);
        }

        public final Collection<Double> getStartPosition() {
            if (this.startPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startPosition;
        }

        public final void setStartPosition(Collection<Double> startPosition) {
            this.startPosition = PositionCopier.copy(startPosition);
        }

        @Override
        public final Builder startPosition(Collection<Double> startPosition) {
            this.startPosition = PositionCopier.copy(startPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startPosition(Double ... startPosition) {
            this.startPosition(Arrays.asList(startPosition));
            return this;
        }

        public final Collection<Double> getEndPosition() {
            if (this.endPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endPosition;
        }

        public final void setEndPosition(Collection<Double> endPosition) {
            this.endPosition = PositionCopier.copy(endPosition);
        }

        @Override
        public final Builder endPosition(Collection<Double> endPosition) {
            this.endPosition = PositionCopier.copy(endPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endPosition(Double ... endPosition) {
            this.endPosition(Arrays.asList(endPosition));
            return this;
        }

        public final Double getDistance() {
            return this.distance;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final Double getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public Step build() {
            return new Step(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Step> {
        public Builder startPosition(Collection<Double> var1);

        public Builder startPosition(Double ... var1);

        public Builder endPosition(Collection<Double> var1);

        public Builder endPosition(Double ... var1);

        public Builder distance(Double var1);

        public Builder durationSeconds(Double var1);

        public Builder geometryOffset(Integer var1);
    }
}

