/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.SearchForSuggestionsResult;
import software.amazon.awssdk.services.location.model.SearchForSuggestionsResultListCopier;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForSuggestionsResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, SearchPlaceIndexForSuggestionsResponse> {
    private static final SdkField<SearchPlaceIndexForSuggestionsSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(SearchPlaceIndexForSuggestionsResponse.getter(SearchPlaceIndexForSuggestionsResponse::summary)).setter(SearchPlaceIndexForSuggestionsResponse.setter(Builder::summary)).constructor(SearchPlaceIndexForSuggestionsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<List<SearchForSuggestionsResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(SearchPlaceIndexForSuggestionsResponse.getter(SearchPlaceIndexForSuggestionsResponse::results)).setter(SearchPlaceIndexForSuggestionsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchForSuggestionsResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Summary", SUMMARY_FIELD);
            this.put("Results", RESULTS_FIELD);
        }
    });
    private final SearchPlaceIndexForSuggestionsSummary summary;
    private final List<SearchForSuggestionsResult> results;

    private SearchPlaceIndexForSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
        this.results = builder.results;
    }

    public final SearchPlaceIndexForSuggestionsSummary summary() {
        return this.summary;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<SearchForSuggestionsResult> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForSuggestionsResponse)) {
            return false;
        }
        SearchPlaceIndexForSuggestionsResponse other = (SearchPlaceIndexForSuggestionsResponse)((Object)obj);
        return Objects.equals(this.summary(), other.summary()) && this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForSuggestionsResponse").add("Summary", (Object)this.summary()).add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForSuggestionsResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForSuggestionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private SearchPlaceIndexForSuggestionsSummary summary;
        private List<SearchForSuggestionsResult> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForSuggestionsResponse model) {
            super(model);
            this.summary(model.summary);
            this.results(model.results);
        }

        public final SearchPlaceIndexForSuggestionsSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(SearchPlaceIndexForSuggestionsSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(SearchPlaceIndexForSuggestionsSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<SearchForSuggestionsResult.Builder> getResults() {
            List<SearchForSuggestionsResult.Builder> result = SearchForSuggestionsResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<SearchForSuggestionsResult.BuilderImpl> results) {
            this.results = SearchForSuggestionsResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<SearchForSuggestionsResult> results) {
            this.results = SearchForSuggestionsResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchForSuggestionsResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchForSuggestionsResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (SearchForSuggestionsResult)((SearchForSuggestionsResult.Builder)SearchForSuggestionsResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchPlaceIndexForSuggestionsResponse build() {
            return new SearchPlaceIndexForSuggestionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForSuggestionsResponse> {
        public Builder summary(SearchPlaceIndexForSuggestionsSummary var1);

        default public Builder summary(Consumer<SearchPlaceIndexForSuggestionsSummary.Builder> summary) {
            return this.summary((SearchPlaceIndexForSuggestionsSummary)((SearchPlaceIndexForSuggestionsSummary.Builder)SearchPlaceIndexForSuggestionsSummary.builder().applyMutation(summary)).build());
        }

        public Builder results(Collection<SearchForSuggestionsResult> var1);

        public Builder results(SearchForSuggestionsResult ... var1);

        public Builder results(Consumer<SearchForSuggestionsResult.Builder> ... var1);
    }
}

