/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.ApiKeyRestrictions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeysResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListKeysResponseEntry> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(ListKeysResponseEntry.getter(ListKeysResponseEntry::keyName)).setter(ListKeysResponseEntry.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<Instant> EXPIRE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpireTime").getter(ListKeysResponseEntry.getter(ListKeysResponseEntry::expireTime)).setter(ListKeysResponseEntry.setter(Builder::expireTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListKeysResponseEntry.getter(ListKeysResponseEntry::description)).setter(ListKeysResponseEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ApiKeyRestrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Restrictions").getter(ListKeysResponseEntry.getter(ListKeysResponseEntry::restrictions)).setter(ListKeysResponseEntry.setter(Builder::restrictions)).constructor(ApiKeyRestrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ListKeysResponseEntry.getter(ListKeysResponseEntry::createTime)).setter(ListKeysResponseEntry.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ListKeysResponseEntry.getter(ListKeysResponseEntry::updateTime)).setter(ListKeysResponseEntry.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, EXPIRE_TIME_FIELD, DESCRIPTION_FIELD, RESTRICTIONS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyName", KEY_NAME_FIELD);
            this.put("ExpireTime", EXPIRE_TIME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Restrictions", RESTRICTIONS_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("UpdateTime", UPDATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String keyName;
    private final Instant expireTime;
    private final String description;
    private final ApiKeyRestrictions restrictions;
    private final Instant createTime;
    private final Instant updateTime;

    private ListKeysResponseEntry(BuilderImpl builder) {
        this.keyName = builder.keyName;
        this.expireTime = builder.expireTime;
        this.description = builder.description;
        this.restrictions = builder.restrictions;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final Instant expireTime() {
        return this.expireTime;
    }

    public final String description() {
        return this.description;
    }

    public final ApiKeyRestrictions restrictions() {
        return this.restrictions;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResponseEntry)) {
            return false;
        }
        ListKeysResponseEntry other = (ListKeysResponseEntry)obj;
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.expireTime(), other.expireTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeysResponseEntry").add("KeyName", (Object)this.keyName()).add("ExpireTime", (Object)this.expireTime()).add("Description", (Object)this.description()).add("Restrictions", (Object)this.restrictions()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "ExpireTime": {
                return Optional.ofNullable(clazz.cast(this.expireTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListKeysResponseEntry, T> g) {
        return obj -> g.apply((ListKeysResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyName;
        private Instant expireTime;
        private String description;
        private ApiKeyRestrictions restrictions;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeysResponseEntry model) {
            this.keyName(model.keyName);
            this.expireTime(model.expireTime);
            this.description(model.description);
            this.restrictions(model.restrictions);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Instant getExpireTime() {
            return this.expireTime;
        }

        public final void setExpireTime(Instant expireTime) {
            this.expireTime = expireTime;
        }

        @Override
        public final Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApiKeyRestrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        public final void setRestrictions(ApiKeyRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(ApiKeyRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ListKeysResponseEntry build() {
            return new ListKeysResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListKeysResponseEntry> {
        public Builder keyName(String var1);

        public Builder expireTime(Instant var1);

        public Builder description(String var1);

        public Builder restrictions(ApiKeyRestrictions var1);

        default public Builder restrictions(Consumer<ApiKeyRestrictions.Builder> restrictions) {
            return this.restrictions((ApiKeyRestrictions)((ApiKeyRestrictions.Builder)ApiKeyRestrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

