/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.ConfidenceScore;
import software.amazon.awssdk.services.lexruntimev2.model.Intent;
import software.amazon.awssdk.services.lexruntimev2.model.InterpretationSource;
import software.amazon.awssdk.services.lexruntimev2.model.SentimentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Interpretation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Interpretation> {
    private static final SdkField<ConfidenceScore> NLU_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nluConfidence").getter(Interpretation.getter(Interpretation::nluConfidence)).setter(Interpretation.setter(Builder::nluConfidence)).constructor(ConfidenceScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluConfidence").build()}).build();
    private static final SdkField<SentimentResponse> SENTIMENT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sentimentResponse").getter(Interpretation.getter(Interpretation::sentimentResponse)).setter(Interpretation.setter(Builder::sentimentResponse)).constructor(SentimentResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentResponse").build()}).build();
    private static final SdkField<Intent> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intent").getter(Interpretation.getter(Interpretation::intent)).setter(Interpretation.setter(Builder::intent)).constructor(Intent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()}).build();
    private static final SdkField<String> INTERPRETATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interpretationSource").getter(Interpretation.getter(Interpretation::interpretationSourceAsString)).setter(Interpretation.setter(Builder::interpretationSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpretationSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NLU_CONFIDENCE_FIELD, SENTIMENT_RESPONSE_FIELD, INTENT_FIELD, INTERPRETATION_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nluConfidence", NLU_CONFIDENCE_FIELD);
            this.put("sentimentResponse", SENTIMENT_RESPONSE_FIELD);
            this.put("intent", INTENT_FIELD);
            this.put("interpretationSource", INTERPRETATION_SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ConfidenceScore nluConfidence;
    private final SentimentResponse sentimentResponse;
    private final Intent intent;
    private final String interpretationSource;

    private Interpretation(BuilderImpl builder) {
        this.nluConfidence = builder.nluConfidence;
        this.sentimentResponse = builder.sentimentResponse;
        this.intent = builder.intent;
        this.interpretationSource = builder.interpretationSource;
    }

    public final ConfidenceScore nluConfidence() {
        return this.nluConfidence;
    }

    public final SentimentResponse sentimentResponse() {
        return this.sentimentResponse;
    }

    public final Intent intent() {
        return this.intent;
    }

    public final InterpretationSource interpretationSource() {
        return InterpretationSource.fromValue(this.interpretationSource);
    }

    public final String interpretationSourceAsString() {
        return this.interpretationSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nluConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.intent());
        hashCode = 31 * hashCode + Objects.hashCode(this.interpretationSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interpretation)) {
            return false;
        }
        Interpretation other = (Interpretation)obj;
        return Objects.equals(this.nluConfidence(), other.nluConfidence()) && Objects.equals(this.sentimentResponse(), other.sentimentResponse()) && Objects.equals(this.intent(), other.intent()) && Objects.equals(this.interpretationSourceAsString(), other.interpretationSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Interpretation").add("NluConfidence", (Object)this.nluConfidence()).add("SentimentResponse", (Object)this.sentimentResponse()).add("Intent", (Object)this.intent()).add("InterpretationSource", (Object)this.interpretationSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nluConfidence": {
                return Optional.ofNullable(clazz.cast(this.nluConfidence()));
            }
            case "sentimentResponse": {
                return Optional.ofNullable(clazz.cast(this.sentimentResponse()));
            }
            case "intent": {
                return Optional.ofNullable(clazz.cast(this.intent()));
            }
            case "interpretationSource": {
                return Optional.ofNullable(clazz.cast(this.interpretationSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Interpretation, T> g) {
        return obj -> g.apply((Interpretation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfidenceScore nluConfidence;
        private SentimentResponse sentimentResponse;
        private Intent intent;
        private String interpretationSource;

        private BuilderImpl() {
        }

        private BuilderImpl(Interpretation model) {
            this.nluConfidence(model.nluConfidence);
            this.sentimentResponse(model.sentimentResponse);
            this.intent(model.intent);
            this.interpretationSource(model.interpretationSource);
        }

        public final ConfidenceScore.Builder getNluConfidence() {
            return this.nluConfidence != null ? this.nluConfidence.toBuilder() : null;
        }

        public final void setNluConfidence(ConfidenceScore.BuilderImpl nluConfidence) {
            this.nluConfidence = nluConfidence != null ? nluConfidence.build() : null;
        }

        @Override
        public final Builder nluConfidence(ConfidenceScore nluConfidence) {
            this.nluConfidence = nluConfidence;
            return this;
        }

        public final SentimentResponse.Builder getSentimentResponse() {
            return this.sentimentResponse != null ? this.sentimentResponse.toBuilder() : null;
        }

        public final void setSentimentResponse(SentimentResponse.BuilderImpl sentimentResponse) {
            this.sentimentResponse = sentimentResponse != null ? sentimentResponse.build() : null;
        }

        @Override
        public final Builder sentimentResponse(SentimentResponse sentimentResponse) {
            this.sentimentResponse = sentimentResponse;
            return this;
        }

        public final Intent.Builder getIntent() {
            return this.intent != null ? this.intent.toBuilder() : null;
        }

        public final void setIntent(Intent.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        public final Builder intent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public final String getInterpretationSource() {
            return this.interpretationSource;
        }

        public final void setInterpretationSource(String interpretationSource) {
            this.interpretationSource = interpretationSource;
        }

        @Override
        public final Builder interpretationSource(String interpretationSource) {
            this.interpretationSource = interpretationSource;
            return this;
        }

        @Override
        public final Builder interpretationSource(InterpretationSource interpretationSource) {
            this.interpretationSource(interpretationSource == null ? null : interpretationSource.toString());
            return this;
        }

        public Interpretation build() {
            return new Interpretation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Interpretation> {
        public Builder nluConfidence(ConfidenceScore var1);

        default public Builder nluConfidence(Consumer<ConfidenceScore.Builder> nluConfidence) {
            return this.nluConfidence((ConfidenceScore)((ConfidenceScore.Builder)ConfidenceScore.builder().applyMutation(nluConfidence)).build());
        }

        public Builder sentimentResponse(SentimentResponse var1);

        default public Builder sentimentResponse(Consumer<SentimentResponse.Builder> sentimentResponse) {
            return this.sentimentResponse((SentimentResponse)((SentimentResponse.Builder)SentimentResponse.builder().applyMutation(sentimentResponse)).build());
        }

        public Builder intent(Intent var1);

        default public Builder intent(Consumer<Intent.Builder> intent) {
            return this.intent((Intent)((Intent.Builder)Intent.builder().applyMutation(intent)).build());
        }

        public Builder interpretationSource(String var1);

        public Builder interpretationSource(InterpretationSource var1);
    }
}

