/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultItem;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelIntentClassificationResultsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultItem;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelSlotResolutionResultsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversationLevelTestResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversationLevelTestResultItem> {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(ConversationLevelTestResultItem.getter(ConversationLevelTestResultItem::conversationId)).setter(ConversationLevelTestResultItem.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> END_TO_END_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endToEndResult").getter(ConversationLevelTestResultItem.getter(ConversationLevelTestResultItem::endToEndResultAsString)).setter(ConversationLevelTestResultItem.setter(Builder::endToEndResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResult").build()}).build();
    private static final SdkField<String> SPEECH_TRANSCRIPTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("speechTranscriptionResult").getter(ConversationLevelTestResultItem.getter(ConversationLevelTestResultItem::speechTranscriptionResultAsString)).setter(ConversationLevelTestResultItem.setter(Builder::speechTranscriptionResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResult").build()}).build();
    private static final SdkField<List<ConversationLevelIntentClassificationResultItem>> INTENT_CLASSIFICATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("intentClassificationResults").getter(ConversationLevelTestResultItem.getter(ConversationLevelTestResultItem::intentClassificationResults)).setter(ConversationLevelTestResultItem.setter(Builder::intentClassificationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClassificationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConversationLevelIntentClassificationResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConversationLevelSlotResolutionResultItem>> SLOT_RESOLUTION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slotResolutionResults").getter(ConversationLevelTestResultItem.getter(ConversationLevelTestResultItem::slotResolutionResults)).setter(ConversationLevelTestResultItem.setter(Builder::slotResolutionResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotResolutionResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConversationLevelSlotResolutionResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD, END_TO_END_RESULT_FIELD, SPEECH_TRANSCRIPTION_RESULT_FIELD, INTENT_CLASSIFICATION_RESULTS_FIELD, SLOT_RESOLUTION_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("conversationId", CONVERSATION_ID_FIELD);
            this.put("endToEndResult", END_TO_END_RESULT_FIELD);
            this.put("speechTranscriptionResult", SPEECH_TRANSCRIPTION_RESULT_FIELD);
            this.put("intentClassificationResults", INTENT_CLASSIFICATION_RESULTS_FIELD);
            this.put("slotResolutionResults", SLOT_RESOLUTION_RESULTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String conversationId;
    private final String endToEndResult;
    private final String speechTranscriptionResult;
    private final List<ConversationLevelIntentClassificationResultItem> intentClassificationResults;
    private final List<ConversationLevelSlotResolutionResultItem> slotResolutionResults;

    private ConversationLevelTestResultItem(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.endToEndResult = builder.endToEndResult;
        this.speechTranscriptionResult = builder.speechTranscriptionResult;
        this.intentClassificationResults = builder.intentClassificationResults;
        this.slotResolutionResults = builder.slotResolutionResults;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final TestResultMatchStatus endToEndResult() {
        return TestResultMatchStatus.fromValue(this.endToEndResult);
    }

    public final String endToEndResultAsString() {
        return this.endToEndResult;
    }

    public final TestResultMatchStatus speechTranscriptionResult() {
        return TestResultMatchStatus.fromValue(this.speechTranscriptionResult);
    }

    public final String speechTranscriptionResultAsString() {
        return this.speechTranscriptionResult;
    }

    public final boolean hasIntentClassificationResults() {
        return this.intentClassificationResults != null && !(this.intentClassificationResults instanceof SdkAutoConstructList);
    }

    public final List<ConversationLevelIntentClassificationResultItem> intentClassificationResults() {
        return this.intentClassificationResults;
    }

    public final boolean hasSlotResolutionResults() {
        return this.slotResolutionResults != null && !(this.slotResolutionResults instanceof SdkAutoConstructList);
    }

    public final List<ConversationLevelSlotResolutionResultItem> slotResolutionResults() {
        return this.slotResolutionResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endToEndResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechTranscriptionResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntentClassificationResults() ? this.intentClassificationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotResolutionResults() ? this.slotResolutionResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLevelTestResultItem)) {
            return false;
        }
        ConversationLevelTestResultItem other = (ConversationLevelTestResultItem)obj;
        return Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.endToEndResultAsString(), other.endToEndResultAsString()) && Objects.equals(this.speechTranscriptionResultAsString(), other.speechTranscriptionResultAsString()) && this.hasIntentClassificationResults() == other.hasIntentClassificationResults() && Objects.equals(this.intentClassificationResults(), other.intentClassificationResults()) && this.hasSlotResolutionResults() == other.hasSlotResolutionResults() && Objects.equals(this.slotResolutionResults(), other.slotResolutionResults());
    }

    public final String toString() {
        return ToString.builder((String)"ConversationLevelTestResultItem").add("ConversationId", (Object)this.conversationId()).add("EndToEndResult", (Object)this.endToEndResultAsString()).add("SpeechTranscriptionResult", (Object)this.speechTranscriptionResultAsString()).add("IntentClassificationResults", this.hasIntentClassificationResults() ? this.intentClassificationResults() : null).add("SlotResolutionResults", this.hasSlotResolutionResults() ? this.slotResolutionResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "endToEndResult": {
                return Optional.ofNullable(clazz.cast(this.endToEndResultAsString()));
            }
            case "speechTranscriptionResult": {
                return Optional.ofNullable(clazz.cast(this.speechTranscriptionResultAsString()));
            }
            case "intentClassificationResults": {
                return Optional.ofNullable(clazz.cast(this.intentClassificationResults()));
            }
            case "slotResolutionResults": {
                return Optional.ofNullable(clazz.cast(this.slotResolutionResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLevelTestResultItem, T> g) {
        return obj -> g.apply((ConversationLevelTestResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conversationId;
        private String endToEndResult;
        private String speechTranscriptionResult;
        private List<ConversationLevelIntentClassificationResultItem> intentClassificationResults = DefaultSdkAutoConstructList.getInstance();
        private List<ConversationLevelSlotResolutionResultItem> slotResolutionResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLevelTestResultItem model) {
            this.conversationId(model.conversationId);
            this.endToEndResult(model.endToEndResult);
            this.speechTranscriptionResult(model.speechTranscriptionResult);
            this.intentClassificationResults(model.intentClassificationResults);
            this.slotResolutionResults(model.slotResolutionResults);
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getEndToEndResult() {
            return this.endToEndResult;
        }

        public final void setEndToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
        }

        @Override
        public final Builder endToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
            return this;
        }

        @Override
        public final Builder endToEndResult(TestResultMatchStatus endToEndResult) {
            this.endToEndResult(endToEndResult == null ? null : endToEndResult.toString());
            return this;
        }

        public final String getSpeechTranscriptionResult() {
            return this.speechTranscriptionResult;
        }

        public final void setSpeechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
        }

        @Override
        public final Builder speechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
            return this;
        }

        @Override
        public final Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult) {
            this.speechTranscriptionResult(speechTranscriptionResult == null ? null : speechTranscriptionResult.toString());
            return this;
        }

        public final List<ConversationLevelIntentClassificationResultItem.Builder> getIntentClassificationResults() {
            List<ConversationLevelIntentClassificationResultItem.Builder> result = ConversationLevelIntentClassificationResultsCopier.copyToBuilder(this.intentClassificationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntentClassificationResults(Collection<ConversationLevelIntentClassificationResultItem.BuilderImpl> intentClassificationResults) {
            this.intentClassificationResults = ConversationLevelIntentClassificationResultsCopier.copyFromBuilder(intentClassificationResults);
        }

        @Override
        public final Builder intentClassificationResults(Collection<ConversationLevelIntentClassificationResultItem> intentClassificationResults) {
            this.intentClassificationResults = ConversationLevelIntentClassificationResultsCopier.copy(intentClassificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentClassificationResults(ConversationLevelIntentClassificationResultItem ... intentClassificationResults) {
            this.intentClassificationResults(Arrays.asList(intentClassificationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intentClassificationResults(Consumer<ConversationLevelIntentClassificationResultItem.Builder> ... intentClassificationResults) {
            this.intentClassificationResults(Stream.of(intentClassificationResults).map(c -> (ConversationLevelIntentClassificationResultItem)((ConversationLevelIntentClassificationResultItem.Builder)ConversationLevelIntentClassificationResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ConversationLevelSlotResolutionResultItem.Builder> getSlotResolutionResults() {
            List<ConversationLevelSlotResolutionResultItem.Builder> result = ConversationLevelSlotResolutionResultsCopier.copyToBuilder(this.slotResolutionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotResolutionResults(Collection<ConversationLevelSlotResolutionResultItem.BuilderImpl> slotResolutionResults) {
            this.slotResolutionResults = ConversationLevelSlotResolutionResultsCopier.copyFromBuilder(slotResolutionResults);
        }

        @Override
        public final Builder slotResolutionResults(Collection<ConversationLevelSlotResolutionResultItem> slotResolutionResults) {
            this.slotResolutionResults = ConversationLevelSlotResolutionResultsCopier.copy(slotResolutionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotResolutionResults(ConversationLevelSlotResolutionResultItem ... slotResolutionResults) {
            this.slotResolutionResults(Arrays.asList(slotResolutionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotResolutionResults(Consumer<ConversationLevelSlotResolutionResultItem.Builder> ... slotResolutionResults) {
            this.slotResolutionResults(Stream.of(slotResolutionResults).map(c -> (ConversationLevelSlotResolutionResultItem)((ConversationLevelSlotResolutionResultItem.Builder)ConversationLevelSlotResolutionResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConversationLevelTestResultItem build() {
            return new ConversationLevelTestResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversationLevelTestResultItem> {
        public Builder conversationId(String var1);

        public Builder endToEndResult(String var1);

        public Builder endToEndResult(TestResultMatchStatus var1);

        public Builder speechTranscriptionResult(String var1);

        public Builder speechTranscriptionResult(TestResultMatchStatus var1);

        public Builder intentClassificationResults(Collection<ConversationLevelIntentClassificationResultItem> var1);

        public Builder intentClassificationResults(ConversationLevelIntentClassificationResultItem ... var1);

        public Builder intentClassificationResults(Consumer<ConversationLevelIntentClassificationResultItem.Builder> ... var1);

        public Builder slotResolutionResults(Collection<ConversationLevelSlotResolutionResultItem> var1);

        public Builder slotResolutionResults(ConversationLevelSlotResolutionResultItem ... var1);

        public Builder slotResolutionResults(Consumer<ConversationLevelSlotResolutionResultItem.Builder> ... var1);
    }
}

