/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig;
import software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfigListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionEventInvokeConfigsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListFunctionEventInvokeConfigsResponse> {
    private static final SdkField<List<FunctionEventInvokeConfig>> FUNCTION_EVENT_INVOKE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionEventInvokeConfigs").getter(ListFunctionEventInvokeConfigsResponse.getter(ListFunctionEventInvokeConfigsResponse::functionEventInvokeConfigs)).setter(ListFunctionEventInvokeConfigsResponse.setter(Builder::functionEventInvokeConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionEventInvokeConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionEventInvokeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListFunctionEventInvokeConfigsResponse.getter(ListFunctionEventInvokeConfigsResponse::nextMarker)).setter(ListFunctionEventInvokeConfigsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_EVENT_INVOKE_CONFIGS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FunctionEventInvokeConfigs", FUNCTION_EVENT_INVOKE_CONFIGS_FIELD);
            this.put("NextMarker", NEXT_MARKER_FIELD);
        }
    });
    private final List<FunctionEventInvokeConfig> functionEventInvokeConfigs;
    private final String nextMarker;

    private ListFunctionEventInvokeConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.functionEventInvokeConfigs = builder.functionEventInvokeConfigs;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasFunctionEventInvokeConfigs() {
        return this.functionEventInvokeConfigs != null && !(this.functionEventInvokeConfigs instanceof SdkAutoConstructList);
    }

    public final List<FunctionEventInvokeConfig> functionEventInvokeConfigs() {
        return this.functionEventInvokeConfigs;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionEventInvokeConfigs() ? this.functionEventInvokeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionEventInvokeConfigsResponse)) {
            return false;
        }
        ListFunctionEventInvokeConfigsResponse other = (ListFunctionEventInvokeConfigsResponse)((Object)obj);
        return this.hasFunctionEventInvokeConfigs() == other.hasFunctionEventInvokeConfigs() && Objects.equals(this.functionEventInvokeConfigs(), other.functionEventInvokeConfigs()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListFunctionEventInvokeConfigsResponse").add("FunctionEventInvokeConfigs", this.hasFunctionEventInvokeConfigs() ? this.functionEventInvokeConfigs() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionEventInvokeConfigs": {
                return Optional.ofNullable(clazz.cast(this.functionEventInvokeConfigs()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionEventInvokeConfigsResponse, T> g) {
        return obj -> g.apply((ListFunctionEventInvokeConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private List<FunctionEventInvokeConfig> functionEventInvokeConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionEventInvokeConfigsResponse model) {
            super(model);
            this.functionEventInvokeConfigs(model.functionEventInvokeConfigs);
            this.nextMarker(model.nextMarker);
        }

        public final List<FunctionEventInvokeConfig.Builder> getFunctionEventInvokeConfigs() {
            List<FunctionEventInvokeConfig.Builder> result = FunctionEventInvokeConfigListCopier.copyToBuilder(this.functionEventInvokeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionEventInvokeConfigs(Collection<FunctionEventInvokeConfig.BuilderImpl> functionEventInvokeConfigs) {
            this.functionEventInvokeConfigs = FunctionEventInvokeConfigListCopier.copyFromBuilder(functionEventInvokeConfigs);
        }

        @Override
        public final Builder functionEventInvokeConfigs(Collection<FunctionEventInvokeConfig> functionEventInvokeConfigs) {
            this.functionEventInvokeConfigs = FunctionEventInvokeConfigListCopier.copy(functionEventInvokeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionEventInvokeConfigs(FunctionEventInvokeConfig ... functionEventInvokeConfigs) {
            this.functionEventInvokeConfigs(Arrays.asList(functionEventInvokeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionEventInvokeConfigs(Consumer<FunctionEventInvokeConfig.Builder> ... functionEventInvokeConfigs) {
            this.functionEventInvokeConfigs(Stream.of(functionEventInvokeConfigs).map(c -> (FunctionEventInvokeConfig)((FunctionEventInvokeConfig.Builder)FunctionEventInvokeConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListFunctionEventInvokeConfigsResponse build() {
            return new ListFunctionEventInvokeConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionEventInvokeConfigsResponse> {
        public Builder functionEventInvokeConfigs(Collection<FunctionEventInvokeConfig> var1);

        public Builder functionEventInvokeConfigs(FunctionEventInvokeConfig ... var1);

        public Builder functionEventInvokeConfigs(Consumer<FunctionEventInvokeConfig.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

