/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.StrategyOnFullSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalSizeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalSizeConfig> {
    private static final SdkField<Integer> MAX_LOCAL_MEDIA_SIZE_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLocalMediaSizeInMB").getter(LocalSizeConfig.getter(LocalSizeConfig::maxLocalMediaSizeInMB)).setter(LocalSizeConfig.setter(Builder::maxLocalMediaSizeInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLocalMediaSizeInMB").build()}).build();
    private static final SdkField<String> STRATEGY_ON_FULL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StrategyOnFullSize").getter(LocalSizeConfig.getter(LocalSizeConfig::strategyOnFullSizeAsString)).setter(LocalSizeConfig.setter(Builder::strategyOnFullSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrategyOnFullSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_LOCAL_MEDIA_SIZE_IN_MB_FIELD, STRATEGY_ON_FULL_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MaxLocalMediaSizeInMB", MAX_LOCAL_MEDIA_SIZE_IN_MB_FIELD);
            this.put("StrategyOnFullSize", STRATEGY_ON_FULL_SIZE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer maxLocalMediaSizeInMB;
    private final String strategyOnFullSize;

    private LocalSizeConfig(BuilderImpl builder) {
        this.maxLocalMediaSizeInMB = builder.maxLocalMediaSizeInMB;
        this.strategyOnFullSize = builder.strategyOnFullSize;
    }

    public final Integer maxLocalMediaSizeInMB() {
        return this.maxLocalMediaSizeInMB;
    }

    public final StrategyOnFullSize strategyOnFullSize() {
        return StrategyOnFullSize.fromValue(this.strategyOnFullSize);
    }

    public final String strategyOnFullSizeAsString() {
        return this.strategyOnFullSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLocalMediaSizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyOnFullSizeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSizeConfig)) {
            return false;
        }
        LocalSizeConfig other = (LocalSizeConfig)obj;
        return Objects.equals(this.maxLocalMediaSizeInMB(), other.maxLocalMediaSizeInMB()) && Objects.equals(this.strategyOnFullSizeAsString(), other.strategyOnFullSizeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LocalSizeConfig").add("MaxLocalMediaSizeInMB", (Object)this.maxLocalMediaSizeInMB()).add("StrategyOnFullSize", (Object)this.strategyOnFullSizeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxLocalMediaSizeInMB": {
                return Optional.ofNullable(clazz.cast(this.maxLocalMediaSizeInMB()));
            }
            case "StrategyOnFullSize": {
                return Optional.ofNullable(clazz.cast(this.strategyOnFullSizeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LocalSizeConfig, T> g) {
        return obj -> g.apply((LocalSizeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxLocalMediaSizeInMB;
        private String strategyOnFullSize;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalSizeConfig model) {
            this.maxLocalMediaSizeInMB(model.maxLocalMediaSizeInMB);
            this.strategyOnFullSize(model.strategyOnFullSize);
        }

        public final Integer getMaxLocalMediaSizeInMB() {
            return this.maxLocalMediaSizeInMB;
        }

        public final void setMaxLocalMediaSizeInMB(Integer maxLocalMediaSizeInMB) {
            this.maxLocalMediaSizeInMB = maxLocalMediaSizeInMB;
        }

        @Override
        public final Builder maxLocalMediaSizeInMB(Integer maxLocalMediaSizeInMB) {
            this.maxLocalMediaSizeInMB = maxLocalMediaSizeInMB;
            return this;
        }

        public final String getStrategyOnFullSize() {
            return this.strategyOnFullSize;
        }

        public final void setStrategyOnFullSize(String strategyOnFullSize) {
            this.strategyOnFullSize = strategyOnFullSize;
        }

        @Override
        public final Builder strategyOnFullSize(String strategyOnFullSize) {
            this.strategyOnFullSize = strategyOnFullSize;
            return this;
        }

        @Override
        public final Builder strategyOnFullSize(StrategyOnFullSize strategyOnFullSize) {
            this.strategyOnFullSize(strategyOnFullSize == null ? null : strategyOnFullSize.toString());
            return this;
        }

        public LocalSizeConfig build() {
            return new LocalSizeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalSizeConfig> {
        public Builder maxLocalMediaSizeInMB(Integer var1);

        public Builder strategyOnFullSize(String var1);

        public Builder strategyOnFullSize(StrategyOnFullSize var1);
    }
}

