/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.DeletionConfig;
import software.amazon.awssdk.services.kinesisvideo.model.RecorderConfig;
import software.amazon.awssdk.services.kinesisvideo.model.UploaderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeConfig> {
    private static final SdkField<String> HUB_DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDeviceArn").getter(EdgeConfig.getter(EdgeConfig::hubDeviceArn)).setter(EdgeConfig.setter(Builder::hubDeviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDeviceArn").build()}).build();
    private static final SdkField<RecorderConfig> RECORDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecorderConfig").getter(EdgeConfig.getter(EdgeConfig::recorderConfig)).setter(EdgeConfig.setter(Builder::recorderConfig)).constructor(RecorderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecorderConfig").build()}).build();
    private static final SdkField<UploaderConfig> UPLOADER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UploaderConfig").getter(EdgeConfig.getter(EdgeConfig::uploaderConfig)).setter(EdgeConfig.setter(Builder::uploaderConfig)).constructor(UploaderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploaderConfig").build()}).build();
    private static final SdkField<DeletionConfig> DELETION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeletionConfig").getter(EdgeConfig.getter(EdgeConfig::deletionConfig)).setter(EdgeConfig.setter(Builder::deletionConfig)).constructor(DeletionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_DEVICE_ARN_FIELD, RECORDER_CONFIG_FIELD, UPLOADER_CONFIG_FIELD, DELETION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HubDeviceArn", HUB_DEVICE_ARN_FIELD);
            this.put("RecorderConfig", RECORDER_CONFIG_FIELD);
            this.put("UploaderConfig", UPLOADER_CONFIG_FIELD);
            this.put("DeletionConfig", DELETION_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String hubDeviceArn;
    private final RecorderConfig recorderConfig;
    private final UploaderConfig uploaderConfig;
    private final DeletionConfig deletionConfig;

    private EdgeConfig(BuilderImpl builder) {
        this.hubDeviceArn = builder.hubDeviceArn;
        this.recorderConfig = builder.recorderConfig;
        this.uploaderConfig = builder.uploaderConfig;
        this.deletionConfig = builder.deletionConfig;
    }

    public final String hubDeviceArn() {
        return this.hubDeviceArn;
    }

    public final RecorderConfig recorderConfig() {
        return this.recorderConfig;
    }

    public final UploaderConfig uploaderConfig() {
        return this.uploaderConfig;
    }

    public final DeletionConfig deletionConfig() {
        return this.deletionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recorderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeConfig)) {
            return false;
        }
        EdgeConfig other = (EdgeConfig)obj;
        return Objects.equals(this.hubDeviceArn(), other.hubDeviceArn()) && Objects.equals(this.recorderConfig(), other.recorderConfig()) && Objects.equals(this.uploaderConfig(), other.uploaderConfig()) && Objects.equals(this.deletionConfig(), other.deletionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeConfig").add("HubDeviceArn", (Object)this.hubDeviceArn()).add("RecorderConfig", (Object)this.recorderConfig()).add("UploaderConfig", (Object)this.uploaderConfig()).add("DeletionConfig", (Object)this.deletionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubDeviceArn": {
                return Optional.ofNullable(clazz.cast(this.hubDeviceArn()));
            }
            case "RecorderConfig": {
                return Optional.ofNullable(clazz.cast(this.recorderConfig()));
            }
            case "UploaderConfig": {
                return Optional.ofNullable(clazz.cast(this.uploaderConfig()));
            }
            case "DeletionConfig": {
                return Optional.ofNullable(clazz.cast(this.deletionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EdgeConfig, T> g) {
        return obj -> g.apply((EdgeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hubDeviceArn;
        private RecorderConfig recorderConfig;
        private UploaderConfig uploaderConfig;
        private DeletionConfig deletionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeConfig model) {
            this.hubDeviceArn(model.hubDeviceArn);
            this.recorderConfig(model.recorderConfig);
            this.uploaderConfig(model.uploaderConfig);
            this.deletionConfig(model.deletionConfig);
        }

        public final String getHubDeviceArn() {
            return this.hubDeviceArn;
        }

        public final void setHubDeviceArn(String hubDeviceArn) {
            this.hubDeviceArn = hubDeviceArn;
        }

        @Override
        public final Builder hubDeviceArn(String hubDeviceArn) {
            this.hubDeviceArn = hubDeviceArn;
            return this;
        }

        public final RecorderConfig.Builder getRecorderConfig() {
            return this.recorderConfig != null ? this.recorderConfig.toBuilder() : null;
        }

        public final void setRecorderConfig(RecorderConfig.BuilderImpl recorderConfig) {
            this.recorderConfig = recorderConfig != null ? recorderConfig.build() : null;
        }

        @Override
        public final Builder recorderConfig(RecorderConfig recorderConfig) {
            this.recorderConfig = recorderConfig;
            return this;
        }

        public final UploaderConfig.Builder getUploaderConfig() {
            return this.uploaderConfig != null ? this.uploaderConfig.toBuilder() : null;
        }

        public final void setUploaderConfig(UploaderConfig.BuilderImpl uploaderConfig) {
            this.uploaderConfig = uploaderConfig != null ? uploaderConfig.build() : null;
        }

        @Override
        public final Builder uploaderConfig(UploaderConfig uploaderConfig) {
            this.uploaderConfig = uploaderConfig;
            return this;
        }

        public final DeletionConfig.Builder getDeletionConfig() {
            return this.deletionConfig != null ? this.deletionConfig.toBuilder() : null;
        }

        public final void setDeletionConfig(DeletionConfig.BuilderImpl deletionConfig) {
            this.deletionConfig = deletionConfig != null ? deletionConfig.build() : null;
        }

        @Override
        public final Builder deletionConfig(DeletionConfig deletionConfig) {
            this.deletionConfig = deletionConfig;
            return this;
        }

        public EdgeConfig build() {
            return new EdgeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeConfig> {
        public Builder hubDeviceArn(String var1);

        public Builder recorderConfig(RecorderConfig var1);

        default public Builder recorderConfig(Consumer<RecorderConfig.Builder> recorderConfig) {
            return this.recorderConfig((RecorderConfig)((RecorderConfig.Builder)RecorderConfig.builder().applyMutation(recorderConfig)).build());
        }

        public Builder uploaderConfig(UploaderConfig var1);

        default public Builder uploaderConfig(Consumer<UploaderConfig.Builder> uploaderConfig) {
            return this.uploaderConfig((UploaderConfig)((UploaderConfig.Builder)UploaderConfig.builder().applyMutation(uploaderConfig)).build());
        }

        public Builder deletionConfig(DeletionConfig var1);

        default public Builder deletionConfig(Consumer<DeletionConfig.Builder> deletionConfig) {
            return this.deletionConfig((DeletionConfig)((DeletionConfig.Builder)DeletionConfig.builder().applyMutation(deletionConfig)).build());
        }
    }
}

