/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.RegionListCopier;
import software.amazon.awssdk.services.keyspaces.model.Rs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationSpecification> {
    private static final SdkField<String> REPLICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationStrategy").getter(ReplicationSpecification.getter(ReplicationSpecification::replicationStrategyAsString)).setter(ReplicationSpecification.setter(Builder::replicationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStrategy").build()}).build();
    private static final SdkField<List<String>> REGION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regionList").getter(ReplicationSpecification.getter(ReplicationSpecification::regionList)).setter(ReplicationSpecification.setter(Builder::regionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_STRATEGY_FIELD, REGION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("replicationStrategy", REPLICATION_STRATEGY_FIELD);
            this.put("regionList", REGION_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String replicationStrategy;
    private final List<String> regionList;

    private ReplicationSpecification(BuilderImpl builder) {
        this.replicationStrategy = builder.replicationStrategy;
        this.regionList = builder.regionList;
    }

    public final Rs replicationStrategy() {
        return Rs.fromValue(this.replicationStrategy);
    }

    public final String replicationStrategyAsString() {
        return this.replicationStrategy;
    }

    public final boolean hasRegionList() {
        return this.regionList != null && !(this.regionList instanceof SdkAutoConstructList);
    }

    public final List<String> regionList() {
        return this.regionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionList() ? this.regionList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSpecification)) {
            return false;
        }
        ReplicationSpecification other = (ReplicationSpecification)obj;
        return Objects.equals(this.replicationStrategyAsString(), other.replicationStrategyAsString()) && this.hasRegionList() == other.hasRegionList() && Objects.equals(this.regionList(), other.regionList());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationSpecification").add("ReplicationStrategy", (Object)this.replicationStrategyAsString()).add("RegionList", this.hasRegionList() ? this.regionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationStrategy": {
                return Optional.ofNullable(clazz.cast(this.replicationStrategyAsString()));
            }
            case "regionList": {
                return Optional.ofNullable(clazz.cast(this.regionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSpecification, T> g) {
        return obj -> g.apply((ReplicationSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationStrategy;
        private List<String> regionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSpecification model) {
            this.replicationStrategy(model.replicationStrategy);
            this.regionList(model.regionList);
        }

        public final String getReplicationStrategy() {
            return this.replicationStrategy;
        }

        public final void setReplicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
        }

        @Override
        public final Builder replicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
            return this;
        }

        @Override
        public final Builder replicationStrategy(Rs replicationStrategy) {
            this.replicationStrategy(replicationStrategy == null ? null : replicationStrategy.toString());
            return this;
        }

        public final Collection<String> getRegionList() {
            if (this.regionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionList;
        }

        public final void setRegionList(Collection<String> regionList) {
            this.regionList = RegionListCopier.copy(regionList);
        }

        @Override
        public final Builder regionList(Collection<String> regionList) {
            this.regionList = RegionListCopier.copy(regionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionList(String ... regionList) {
            this.regionList(Arrays.asList(regionList));
            return this;
        }

        public ReplicationSpecification build() {
            return new ReplicationSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationSpecification> {
        public Builder replicationStrategy(String var1);

        public Builder replicationStrategy(Rs var1);

        public Builder regionList(Collection<String> var1);

        public Builder regionList(String ... var1);
    }
}

