/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendraranking.model.KendraRankingResponse;
import software.amazon.awssdk.services.kendraranking.model.RescoreResultItem;
import software.amazon.awssdk.services.kendraranking.model.RescoreResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RescoreResponse
extends KendraRankingResponse
implements ToCopyableBuilder<Builder, RescoreResponse> {
    private static final SdkField<String> RESCORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RescoreId").getter(RescoreResponse.getter(RescoreResponse::rescoreId)).setter(RescoreResponse.setter(Builder::rescoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RescoreId").build()}).build();
    private static final SdkField<List<RescoreResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(RescoreResponse.getter(RescoreResponse::resultItems)).setter(RescoreResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RescoreResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESCORE_ID_FIELD, RESULT_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RescoreId", RESCORE_ID_FIELD);
            this.put("ResultItems", RESULT_ITEMS_FIELD);
        }
    });
    private final String rescoreId;
    private final List<RescoreResultItem> resultItems;

    private RescoreResponse(BuilderImpl builder) {
        super(builder);
        this.rescoreId = builder.rescoreId;
        this.resultItems = builder.resultItems;
    }

    public final String rescoreId() {
        return this.rescoreId;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<RescoreResultItem> resultItems() {
        return this.resultItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rescoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RescoreResponse)) {
            return false;
        }
        RescoreResponse other = (RescoreResponse)((Object)obj);
        return Objects.equals(this.rescoreId(), other.rescoreId()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems());
    }

    public final String toString() {
        return ToString.builder((String)"RescoreResponse").add("RescoreId", (Object)this.rescoreId()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RescoreId": {
                return Optional.ofNullable(clazz.cast(this.rescoreId()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RescoreResponse, T> g) {
        return obj -> g.apply((RescoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRankingResponse.BuilderImpl
    implements Builder {
        private String rescoreId;
        private List<RescoreResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RescoreResponse model) {
            super(model);
            this.rescoreId(model.rescoreId);
            this.resultItems(model.resultItems);
        }

        public final String getRescoreId() {
            return this.rescoreId;
        }

        public final void setRescoreId(String rescoreId) {
            this.rescoreId = rescoreId;
        }

        @Override
        public final Builder rescoreId(String rescoreId) {
            this.rescoreId = rescoreId;
            return this;
        }

        public final List<RescoreResultItem.Builder> getResultItems() {
            List<RescoreResultItem.Builder> result = RescoreResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<RescoreResultItem.BuilderImpl> resultItems) {
            this.resultItems = RescoreResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<RescoreResultItem> resultItems) {
            this.resultItems = RescoreResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(RescoreResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<RescoreResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (RescoreResultItem)((RescoreResultItem.Builder)RescoreResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RescoreResponse build() {
            return new RescoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRankingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RescoreResponse> {
        public Builder rescoreId(String var1);

        public Builder resultItems(Collection<RescoreResultItem> var1);

        public Builder resultItems(RescoreResultItem ... var1);

        public Builder resultItems(Consumer<RescoreResultItem.Builder> ... var1);
    }
}

