/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse;
import software.amazon.awssdk.services.kafka.model.ReplicatorSummary;

public class ListReplicatorsIterable
implements SdkIterable<ListReplicatorsResponse> {
    private final KafkaClient client;
    private final ListReplicatorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReplicatorsIterable(KafkaClient client, ListReplicatorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReplicatorsResponseFetcher();
    }

    public Iterator<ListReplicatorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReplicatorSummary> replicators() {
        Function<ListReplicatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicators() != null) {
                return response.replicators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReplicatorsResponseFetcher
    implements SyncPageFetcher<ListReplicatorsResponse> {
        private ListReplicatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListReplicatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReplicatorsResponse nextPage(ListReplicatorsResponse previousPage) {
            if (previousPage == null) {
                return ListReplicatorsIterable.this.client.listReplicators(ListReplicatorsIterable.this.firstRequest);
            }
            return ListReplicatorsIterable.this.client.listReplicators((ListReplicatorsRequest)((Object)ListReplicatorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

