/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerCountRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateBrokerCountRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateBrokerCountRequest.getter(UpdateBrokerCountRequest::clusterArn)).setter(UpdateBrokerCountRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateBrokerCountRequest.getter(UpdateBrokerCountRequest::currentVersion)).setter(UpdateBrokerCountRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<Integer> TARGET_NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetNumberOfBrokerNodes").getter(UpdateBrokerCountRequest.getter(UpdateBrokerCountRequest::targetNumberOfBrokerNodes)).setter(UpdateBrokerCountRequest.setter(Builder::targetNumberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNumberOfBrokerNodes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, TARGET_NUMBER_OF_BROKER_NODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("currentVersion", CURRENT_VERSION_FIELD);
            this.put("targetNumberOfBrokerNodes", TARGET_NUMBER_OF_BROKER_NODES_FIELD);
        }
    });
    private final String clusterArn;
    private final String currentVersion;
    private final Integer targetNumberOfBrokerNodes;

    private UpdateBrokerCountRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.targetNumberOfBrokerNodes = builder.targetNumberOfBrokerNodes;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final Integer targetNumberOfBrokerNodes() {
        return this.targetNumberOfBrokerNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNumberOfBrokerNodes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerCountRequest)) {
            return false;
        }
        UpdateBrokerCountRequest other = (UpdateBrokerCountRequest)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.targetNumberOfBrokerNodes(), other.targetNumberOfBrokerNodes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrokerCountRequest").add("ClusterArn", (Object)this.clusterArn()).add("CurrentVersion", (Object)this.currentVersion()).add("TargetNumberOfBrokerNodes", (Object)this.targetNumberOfBrokerNodes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "TargetNumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.targetNumberOfBrokerNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerCountRequest, T> g) {
        return obj -> g.apply((UpdateBrokerCountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String currentVersion;
        private Integer targetNumberOfBrokerNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerCountRequest model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.currentVersion(model.currentVersion);
            this.targetNumberOfBrokerNodes(model.targetNumberOfBrokerNodes);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final Integer getTargetNumberOfBrokerNodes() {
            return this.targetNumberOfBrokerNodes;
        }

        public final void setTargetNumberOfBrokerNodes(Integer targetNumberOfBrokerNodes) {
            this.targetNumberOfBrokerNodes = targetNumberOfBrokerNodes;
        }

        @Override
        public final Builder targetNumberOfBrokerNodes(Integer targetNumberOfBrokerNodes) {
            this.targetNumberOfBrokerNodes = targetNumberOfBrokerNodes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerCountRequest build() {
            return new UpdateBrokerCountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrokerCountRequest> {
        public Builder clusterArn(String var1);

        public Builder currentVersion(String var1);

        public Builder targetNumberOfBrokerNodes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

