/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KafkaVersionStatus {
    ACTIVE("ACTIVE"),
    DEPRECATED("DEPRECATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KafkaVersionStatus> VALUE_MAP;
    private final String value;

    private KafkaVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KafkaVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KafkaVersionStatus> knownValues() {
        EnumSet<KafkaVersionStatus> knownValues = EnumSet.allOf(KafkaVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KafkaVersionStatus.class, KafkaVersionStatus::toString);
    }
}

