/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary;

public class ListPublicKeysPublisher
implements SdkPublisher<ListPublicKeysResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListPublicKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPublicKeysPublisher(IvsRealTimeAsyncClient client, ListPublicKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPublicKeysPublisher(IvsRealTimeAsyncClient client, ListPublicKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPublicKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPublicKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PublicKeySummary> publicKeys() {
        Function<ListPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.publicKeys() != null) {
                return response.publicKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPublicKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPublicKeysResponseFetcher
    implements AsyncPageFetcher<ListPublicKeysResponse> {
        private ListPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListPublicKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPublicKeysResponse> nextPage(ListPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListPublicKeysPublisher.this.client.listPublicKeys(ListPublicKeysPublisher.this.firstRequest);
            }
            return ListPublicKeysPublisher.this.client.listPublicKeys((ListPublicKeysRequest)((Object)ListPublicKeysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

