/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.GridConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.PipConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayoutConfiguration> {
    private static final SdkField<GridConfiguration> GRID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grid").getter(LayoutConfiguration.getter(LayoutConfiguration::grid)).setter(LayoutConfiguration.setter(Builder::grid)).constructor(GridConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grid").build()}).build();
    private static final SdkField<PipConfiguration> PIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pip").getter(LayoutConfiguration.getter(LayoutConfiguration::pip)).setter(LayoutConfiguration.setter(Builder::pip)).constructor(PipConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pip").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRID_FIELD, PIP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("grid", GRID_FIELD);
            this.put("pip", PIP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final GridConfiguration grid;
    private final PipConfiguration pip;

    private LayoutConfiguration(BuilderImpl builder) {
        this.grid = builder.grid;
        this.pip = builder.pip;
    }

    public final GridConfiguration grid() {
        return this.grid;
    }

    public final PipConfiguration pip() {
        return this.pip;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pip());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutConfiguration)) {
            return false;
        }
        LayoutConfiguration other = (LayoutConfiguration)obj;
        return Objects.equals(this.grid(), other.grid()) && Objects.equals(this.pip(), other.pip());
    }

    public final String toString() {
        return ToString.builder((String)"LayoutConfiguration").add("Grid", (Object)this.grid()).add("Pip", (Object)this.pip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grid": {
                return Optional.ofNullable(clazz.cast(this.grid()));
            }
            case "pip": {
                return Optional.ofNullable(clazz.cast(this.pip()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LayoutConfiguration, T> g) {
        return obj -> g.apply((LayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GridConfiguration grid;
        private PipConfiguration pip;

        private BuilderImpl() {
        }

        private BuilderImpl(LayoutConfiguration model) {
            this.grid(model.grid);
            this.pip(model.pip);
        }

        public final GridConfiguration.Builder getGrid() {
            return this.grid != null ? this.grid.toBuilder() : null;
        }

        public final void setGrid(GridConfiguration.BuilderImpl grid) {
            this.grid = grid != null ? grid.build() : null;
        }

        @Override
        public final Builder grid(GridConfiguration grid) {
            this.grid = grid;
            return this;
        }

        public final PipConfiguration.Builder getPip() {
            return this.pip != null ? this.pip.toBuilder() : null;
        }

        public final void setPip(PipConfiguration.BuilderImpl pip) {
            this.pip = pip != null ? pip.build() : null;
        }

        @Override
        public final Builder pip(PipConfiguration pip) {
            this.pip = pip;
            return this;
        }

        public LayoutConfiguration build() {
            return new LayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayoutConfiguration> {
        public Builder grid(GridConfiguration var1);

        default public Builder grid(Consumer<GridConfiguration.Builder> grid) {
            return this.grid((GridConfiguration)((GridConfiguration.Builder)GridConfiguration.builder().applyMutation(grid)).build());
        }

        public Builder pip(PipConfiguration var1);

        default public Builder pip(Consumer<PipConfiguration.Builder> pip) {
            return this.pip((PipConfiguration)((PipConfiguration.Builder)PipConfiguration.builder().applyMutation(pip)).build());
        }
    }
}

