/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.RecordingMode;
import software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution;
import software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage;
import software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThumbnailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThumbnailConfiguration> {
    private static final SdkField<String> RECORDING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingMode").getter(ThumbnailConfiguration.getter(ThumbnailConfiguration::recordingModeAsString)).setter(ThumbnailConfiguration.setter(Builder::recordingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingMode").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolution").getter(ThumbnailConfiguration.getter(ThumbnailConfiguration::resolutionAsString)).setter(ThumbnailConfiguration.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()}).build();
    private static final SdkField<List<String>> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storage").getter(ThumbnailConfiguration.getter(ThumbnailConfiguration::storageAsStrings)).setter(ThumbnailConfiguration.setter(Builder::storageWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TARGET_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetIntervalSeconds").getter(ThumbnailConfiguration.getter(ThumbnailConfiguration::targetIntervalSeconds)).setter(ThumbnailConfiguration.setter(Builder::targetIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIntervalSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDING_MODE_FIELD, RESOLUTION_FIELD, STORAGE_FIELD, TARGET_INTERVAL_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("recordingMode", RECORDING_MODE_FIELD);
            this.put("resolution", RESOLUTION_FIELD);
            this.put("storage", STORAGE_FIELD);
            this.put("targetIntervalSeconds", TARGET_INTERVAL_SECONDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String recordingMode;
    private final String resolution;
    private final List<String> storage;
    private final Long targetIntervalSeconds;

    private ThumbnailConfiguration(BuilderImpl builder) {
        this.recordingMode = builder.recordingMode;
        this.resolution = builder.resolution;
        this.storage = builder.storage;
        this.targetIntervalSeconds = builder.targetIntervalSeconds;
    }

    public final RecordingMode recordingMode() {
        return RecordingMode.fromValue(this.recordingMode);
    }

    public final String recordingModeAsString() {
        return this.recordingMode;
    }

    public final ThumbnailConfigurationResolution resolution() {
        return ThumbnailConfigurationResolution.fromValue(this.resolution);
    }

    public final String resolutionAsString() {
        return this.resolution;
    }

    public final List<ThumbnailConfigurationStorage> storage() {
        return ThumbnailConfigurationStorageListCopier.copyStringToEnum(this.storage);
    }

    public final boolean hasStorage() {
        return this.storage != null && !(this.storage instanceof SdkAutoConstructList);
    }

    public final List<String> storageAsStrings() {
        return this.storage;
    }

    public final Long targetIntervalSeconds() {
        return this.targetIntervalSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorage() ? this.storageAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIntervalSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailConfiguration)) {
            return false;
        }
        ThumbnailConfiguration other = (ThumbnailConfiguration)obj;
        return Objects.equals(this.recordingModeAsString(), other.recordingModeAsString()) && Objects.equals(this.resolutionAsString(), other.resolutionAsString()) && this.hasStorage() == other.hasStorage() && Objects.equals(this.storageAsStrings(), other.storageAsStrings()) && Objects.equals(this.targetIntervalSeconds(), other.targetIntervalSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"ThumbnailConfiguration").add("RecordingMode", (Object)this.recordingModeAsString()).add("Resolution", (Object)this.resolutionAsString()).add("Storage", this.hasStorage() ? this.storageAsStrings() : null).add("TargetIntervalSeconds", (Object)this.targetIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recordingMode": {
                return Optional.ofNullable(clazz.cast(this.recordingModeAsString()));
            }
            case "resolution": {
                return Optional.ofNullable(clazz.cast(this.resolutionAsString()));
            }
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storageAsStrings()));
            }
            case "targetIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.targetIntervalSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailConfiguration, T> g) {
        return obj -> g.apply((ThumbnailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordingMode;
        private String resolution;
        private List<String> storage = DefaultSdkAutoConstructList.getInstance();
        private Long targetIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailConfiguration model) {
            this.recordingMode(model.recordingMode);
            this.resolution(model.resolution);
            this.storageWithStrings(model.storage);
            this.targetIntervalSeconds(model.targetIntervalSeconds);
        }

        public final String getRecordingMode() {
            return this.recordingMode;
        }

        public final void setRecordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
        }

        @Override
        public final Builder recordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        @Override
        public final Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode(recordingMode == null ? null : recordingMode.toString());
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(ThumbnailConfigurationResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final Collection<String> getStorage() {
            if (this.storage instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storage;
        }

        public final void setStorage(Collection<String> storage) {
            this.storage = ThumbnailConfigurationStorageListCopier.copy(storage);
        }

        @Override
        public final Builder storageWithStrings(Collection<String> storage) {
            this.storage = ThumbnailConfigurationStorageListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageWithStrings(String ... storage) {
            this.storageWithStrings(Arrays.asList(storage));
            return this;
        }

        @Override
        public final Builder storage(Collection<ThumbnailConfigurationStorage> storage) {
            this.storage = ThumbnailConfigurationStorageListCopier.copyEnumToString(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ThumbnailConfigurationStorage ... storage) {
            this.storage(Arrays.asList(storage));
            return this;
        }

        public final Long getTargetIntervalSeconds() {
            return this.targetIntervalSeconds;
        }

        public final void setTargetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
        }

        @Override
        public final Builder targetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
            return this;
        }

        public ThumbnailConfiguration build() {
            return new ThumbnailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThumbnailConfiguration> {
        public Builder recordingMode(String var1);

        public Builder recordingMode(RecordingMode var1);

        public Builder resolution(String var1);

        public Builder resolution(ThumbnailConfigurationResolution var1);

        public Builder storageWithStrings(Collection<String> var1);

        public Builder storageWithStrings(String ... var1);

        public Builder storage(Collection<ThumbnailConfigurationStorage> var1);

        public Builder storage(ThumbnailConfigurationStorage ... var1);

        public Builder targetIntervalSeconds(Long var1);
    }
}

