/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, ListChannelsRequest> {
    private static final SdkField<String> FILTER_BY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByName").getter(ListChannelsRequest.getter(ListChannelsRequest::filterByName)).setter(ListChannelsRequest.setter(Builder::filterByName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByName").build()}).build();
    private static final SdkField<String> FILTER_BY_PLAYBACK_RESTRICTION_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByPlaybackRestrictionPolicyArn").getter(ListChannelsRequest.getter(ListChannelsRequest::filterByPlaybackRestrictionPolicyArn)).setter(ListChannelsRequest.setter(Builder::filterByPlaybackRestrictionPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByPlaybackRestrictionPolicyArn").build()}).build();
    private static final SdkField<String> FILTER_BY_RECORDING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterByRecordingConfigurationArn").getter(ListChannelsRequest.getter(ListChannelsRequest::filterByRecordingConfigurationArn)).setter(ListChannelsRequest.setter(Builder::filterByRecordingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterByRecordingConfigurationArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListChannelsRequest.getter(ListChannelsRequest::maxResults)).setter(ListChannelsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListChannelsRequest.getter(ListChannelsRequest::nextToken)).setter(ListChannelsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_NAME_FIELD, FILTER_BY_PLAYBACK_RESTRICTION_POLICY_ARN_FIELD, FILTER_BY_RECORDING_CONFIGURATION_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("filterByName", FILTER_BY_NAME_FIELD);
            this.put("filterByPlaybackRestrictionPolicyArn", FILTER_BY_PLAYBACK_RESTRICTION_POLICY_ARN_FIELD);
            this.put("filterByRecordingConfigurationArn", FILTER_BY_RECORDING_CONFIGURATION_ARN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String filterByName;
    private final String filterByPlaybackRestrictionPolicyArn;
    private final String filterByRecordingConfigurationArn;
    private final Integer maxResults;
    private final String nextToken;

    private ListChannelsRequest(BuilderImpl builder) {
        super(builder);
        this.filterByName = builder.filterByName;
        this.filterByPlaybackRestrictionPolicyArn = builder.filterByPlaybackRestrictionPolicyArn;
        this.filterByRecordingConfigurationArn = builder.filterByRecordingConfigurationArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String filterByName() {
        return this.filterByName;
    }

    public final String filterByPlaybackRestrictionPolicyArn() {
        return this.filterByPlaybackRestrictionPolicyArn;
    }

    public final String filterByRecordingConfigurationArn() {
        return this.filterByRecordingConfigurationArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByPlaybackRestrictionPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterByRecordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsRequest)) {
            return false;
        }
        ListChannelsRequest other = (ListChannelsRequest)((Object)obj);
        return Objects.equals(this.filterByName(), other.filterByName()) && Objects.equals(this.filterByPlaybackRestrictionPolicyArn(), other.filterByPlaybackRestrictionPolicyArn()) && Objects.equals(this.filterByRecordingConfigurationArn(), other.filterByRecordingConfigurationArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelsRequest").add("FilterByName", (Object)this.filterByName()).add("FilterByPlaybackRestrictionPolicyArn", (Object)this.filterByPlaybackRestrictionPolicyArn()).add("FilterByRecordingConfigurationArn", (Object)this.filterByRecordingConfigurationArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterByName": {
                return Optional.ofNullable(clazz.cast(this.filterByName()));
            }
            case "filterByPlaybackRestrictionPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.filterByPlaybackRestrictionPolicyArn()));
            }
            case "filterByRecordingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.filterByRecordingConfigurationArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsRequest, T> g) {
        return obj -> g.apply((ListChannelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private String filterByName;
        private String filterByPlaybackRestrictionPolicyArn;
        private String filterByRecordingConfigurationArn;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsRequest model) {
            super(model);
            this.filterByName(model.filterByName);
            this.filterByPlaybackRestrictionPolicyArn(model.filterByPlaybackRestrictionPolicyArn);
            this.filterByRecordingConfigurationArn(model.filterByRecordingConfigurationArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getFilterByName() {
            return this.filterByName;
        }

        public final void setFilterByName(String filterByName) {
            this.filterByName = filterByName;
        }

        @Override
        public final Builder filterByName(String filterByName) {
            this.filterByName = filterByName;
            return this;
        }

        public final String getFilterByPlaybackRestrictionPolicyArn() {
            return this.filterByPlaybackRestrictionPolicyArn;
        }

        public final void setFilterByPlaybackRestrictionPolicyArn(String filterByPlaybackRestrictionPolicyArn) {
            this.filterByPlaybackRestrictionPolicyArn = filterByPlaybackRestrictionPolicyArn;
        }

        @Override
        public final Builder filterByPlaybackRestrictionPolicyArn(String filterByPlaybackRestrictionPolicyArn) {
            this.filterByPlaybackRestrictionPolicyArn = filterByPlaybackRestrictionPolicyArn;
            return this;
        }

        public final String getFilterByRecordingConfigurationArn() {
            return this.filterByRecordingConfigurationArn;
        }

        public final void setFilterByRecordingConfigurationArn(String filterByRecordingConfigurationArn) {
            this.filterByRecordingConfigurationArn = filterByRecordingConfigurationArn;
        }

        @Override
        public final Builder filterByRecordingConfigurationArn(String filterByRecordingConfigurationArn) {
            this.filterByRecordingConfigurationArn = filterByRecordingConfigurationArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChannelsRequest build() {
            return new ListChannelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelsRequest> {
        public Builder filterByName(String var1);

        public Builder filterByPlaybackRestrictionPolicyArn(String var1);

        public Builder filterByRecordingConfigurationArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

