/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.CdmaListCopier;
import software.amazon.awssdk.services.iotwireless.model.CdmaObj;
import software.amazon.awssdk.services.iotwireless.model.GsmListCopier;
import software.amazon.awssdk.services.iotwireless.model.GsmObj;
import software.amazon.awssdk.services.iotwireless.model.LteListCopier;
import software.amazon.awssdk.services.iotwireless.model.LteObj;
import software.amazon.awssdk.services.iotwireless.model.TdscdmaListCopier;
import software.amazon.awssdk.services.iotwireless.model.TdscdmaObj;
import software.amazon.awssdk.services.iotwireless.model.WcdmaListCopier;
import software.amazon.awssdk.services.iotwireless.model.WcdmaObj;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CellTowers
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CellTowers> {
    private static final SdkField<List<GsmObj>> GSM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Gsm").getter(CellTowers.getter(CellTowers::gsm)).setter(CellTowers.setter(Builder::gsm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gsm").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GsmObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WcdmaObj>> WCDMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Wcdma").getter(CellTowers.getter(CellTowers::wcdma)).setter(CellTowers.setter(Builder::wcdma)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wcdma").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WcdmaObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TdscdmaObj>> TDSCDMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tdscdma").getter(CellTowers.getter(CellTowers::tdscdma)).setter(CellTowers.setter(Builder::tdscdma)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tdscdma").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TdscdmaObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LteObj>> LTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lte").getter(CellTowers.getter(CellTowers::lte)).setter(CellTowers.setter(Builder::lte)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lte").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LteObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CdmaObj>> CDMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cdma").getter(CellTowers.getter(CellTowers::cdma)).setter(CellTowers.setter(Builder::cdma)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cdma").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CdmaObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GSM_FIELD, WCDMA_FIELD, TDSCDMA_FIELD, LTE_FIELD, CDMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Gsm", GSM_FIELD);
            this.put("Wcdma", WCDMA_FIELD);
            this.put("Tdscdma", TDSCDMA_FIELD);
            this.put("Lte", LTE_FIELD);
            this.put("Cdma", CDMA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<GsmObj> gsm;
    private final List<WcdmaObj> wcdma;
    private final List<TdscdmaObj> tdscdma;
    private final List<LteObj> lte;
    private final List<CdmaObj> cdma;

    private CellTowers(BuilderImpl builder) {
        this.gsm = builder.gsm;
        this.wcdma = builder.wcdma;
        this.tdscdma = builder.tdscdma;
        this.lte = builder.lte;
        this.cdma = builder.cdma;
    }

    public final boolean hasGsm() {
        return this.gsm != null && !(this.gsm instanceof SdkAutoConstructList);
    }

    public final List<GsmObj> gsm() {
        return this.gsm;
    }

    public final boolean hasWcdma() {
        return this.wcdma != null && !(this.wcdma instanceof SdkAutoConstructList);
    }

    public final List<WcdmaObj> wcdma() {
        return this.wcdma;
    }

    public final boolean hasTdscdma() {
        return this.tdscdma != null && !(this.tdscdma instanceof SdkAutoConstructList);
    }

    public final List<TdscdmaObj> tdscdma() {
        return this.tdscdma;
    }

    public final boolean hasLte() {
        return this.lte != null && !(this.lte instanceof SdkAutoConstructList);
    }

    public final List<LteObj> lte() {
        return this.lte;
    }

    public final boolean hasCdma() {
        return this.cdma != null && !(this.cdma instanceof SdkAutoConstructList);
    }

    public final List<CdmaObj> cdma() {
        return this.cdma;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGsm() ? this.gsm() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWcdma() ? this.wcdma() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTdscdma() ? this.tdscdma() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLte() ? this.lte() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCdma() ? this.cdma() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellTowers)) {
            return false;
        }
        CellTowers other = (CellTowers)obj;
        return this.hasGsm() == other.hasGsm() && Objects.equals(this.gsm(), other.gsm()) && this.hasWcdma() == other.hasWcdma() && Objects.equals(this.wcdma(), other.wcdma()) && this.hasTdscdma() == other.hasTdscdma() && Objects.equals(this.tdscdma(), other.tdscdma()) && this.hasLte() == other.hasLte() && Objects.equals(this.lte(), other.lte()) && this.hasCdma() == other.hasCdma() && Objects.equals(this.cdma(), other.cdma());
    }

    public final String toString() {
        return ToString.builder((String)"CellTowers").add("Gsm", this.hasGsm() ? this.gsm() : null).add("Wcdma", this.hasWcdma() ? this.wcdma() : null).add("Tdscdma", this.hasTdscdma() ? this.tdscdma() : null).add("Lte", this.hasLte() ? this.lte() : null).add("Cdma", this.hasCdma() ? this.cdma() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gsm": {
                return Optional.ofNullable(clazz.cast(this.gsm()));
            }
            case "Wcdma": {
                return Optional.ofNullable(clazz.cast(this.wcdma()));
            }
            case "Tdscdma": {
                return Optional.ofNullable(clazz.cast(this.tdscdma()));
            }
            case "Lte": {
                return Optional.ofNullable(clazz.cast(this.lte()));
            }
            case "Cdma": {
                return Optional.ofNullable(clazz.cast(this.cdma()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CellTowers, T> g) {
        return obj -> g.apply((CellTowers)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GsmObj> gsm = DefaultSdkAutoConstructList.getInstance();
        private List<WcdmaObj> wcdma = DefaultSdkAutoConstructList.getInstance();
        private List<TdscdmaObj> tdscdma = DefaultSdkAutoConstructList.getInstance();
        private List<LteObj> lte = DefaultSdkAutoConstructList.getInstance();
        private List<CdmaObj> cdma = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CellTowers model) {
            this.gsm(model.gsm);
            this.wcdma(model.wcdma);
            this.tdscdma(model.tdscdma);
            this.lte(model.lte);
            this.cdma(model.cdma);
        }

        public final List<GsmObj.Builder> getGsm() {
            List<GsmObj.Builder> result = GsmListCopier.copyToBuilder(this.gsm);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGsm(Collection<GsmObj.BuilderImpl> gsm) {
            this.gsm = GsmListCopier.copyFromBuilder(gsm);
        }

        @Override
        public final Builder gsm(Collection<GsmObj> gsm) {
            this.gsm = GsmListCopier.copy(gsm);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsm(GsmObj ... gsm) {
            this.gsm(Arrays.asList(gsm));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsm(Consumer<GsmObj.Builder> ... gsm) {
            this.gsm(Stream.of(gsm).map(c -> (GsmObj)((GsmObj.Builder)GsmObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WcdmaObj.Builder> getWcdma() {
            List<WcdmaObj.Builder> result = WcdmaListCopier.copyToBuilder(this.wcdma);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWcdma(Collection<WcdmaObj.BuilderImpl> wcdma) {
            this.wcdma = WcdmaListCopier.copyFromBuilder(wcdma);
        }

        @Override
        public final Builder wcdma(Collection<WcdmaObj> wcdma) {
            this.wcdma = WcdmaListCopier.copy(wcdma);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdma(WcdmaObj ... wcdma) {
            this.wcdma(Arrays.asList(wcdma));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wcdma(Consumer<WcdmaObj.Builder> ... wcdma) {
            this.wcdma(Stream.of(wcdma).map(c -> (WcdmaObj)((WcdmaObj.Builder)WcdmaObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TdscdmaObj.Builder> getTdscdma() {
            List<TdscdmaObj.Builder> result = TdscdmaListCopier.copyToBuilder(this.tdscdma);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTdscdma(Collection<TdscdmaObj.BuilderImpl> tdscdma) {
            this.tdscdma = TdscdmaListCopier.copyFromBuilder(tdscdma);
        }

        @Override
        public final Builder tdscdma(Collection<TdscdmaObj> tdscdma) {
            this.tdscdma = TdscdmaListCopier.copy(tdscdma);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tdscdma(TdscdmaObj ... tdscdma) {
            this.tdscdma(Arrays.asList(tdscdma));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tdscdma(Consumer<TdscdmaObj.Builder> ... tdscdma) {
            this.tdscdma(Stream.of(tdscdma).map(c -> (TdscdmaObj)((TdscdmaObj.Builder)TdscdmaObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LteObj.Builder> getLte() {
            List<LteObj.Builder> result = LteListCopier.copyToBuilder(this.lte);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLte(Collection<LteObj.BuilderImpl> lte) {
            this.lte = LteListCopier.copyFromBuilder(lte);
        }

        @Override
        public final Builder lte(Collection<LteObj> lte) {
            this.lte = LteListCopier.copy(lte);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lte(LteObj ... lte) {
            this.lte(Arrays.asList(lte));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lte(Consumer<LteObj.Builder> ... lte) {
            this.lte(Stream.of(lte).map(c -> (LteObj)((LteObj.Builder)LteObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CdmaObj.Builder> getCdma() {
            List<CdmaObj.Builder> result = CdmaListCopier.copyToBuilder(this.cdma);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCdma(Collection<CdmaObj.BuilderImpl> cdma) {
            this.cdma = CdmaListCopier.copyFromBuilder(cdma);
        }

        @Override
        public final Builder cdma(Collection<CdmaObj> cdma) {
            this.cdma = CdmaListCopier.copy(cdma);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdma(CdmaObj ... cdma) {
            this.cdma(Arrays.asList(cdma));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdma(Consumer<CdmaObj.Builder> ... cdma) {
            this.cdma(Stream.of(cdma).map(c -> (CdmaObj)((CdmaObj.Builder)CdmaObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CellTowers build() {
            return new CellTowers(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CellTowers> {
        public Builder gsm(Collection<GsmObj> var1);

        public Builder gsm(GsmObj ... var1);

        public Builder gsm(Consumer<GsmObj.Builder> ... var1);

        public Builder wcdma(Collection<WcdmaObj> var1);

        public Builder wcdma(WcdmaObj ... var1);

        public Builder wcdma(Consumer<WcdmaObj.Builder> ... var1);

        public Builder tdscdma(Collection<TdscdmaObj> var1);

        public Builder tdscdma(TdscdmaObj ... var1);

        public Builder tdscdma(Consumer<TdscdmaObj.Builder> ... var1);

        public Builder lte(Collection<LteObj> var1);

        public Builder lte(LteObj ... var1);

        public Builder lte(Consumer<LteObj.Builder> ... var1);

        public Builder cdma(Collection<CdmaObj> var1);

        public Builder cdma(CdmaObj ... var1);

        public Builder cdma(Consumer<CdmaObj.Builder> ... var1);
    }
}

