/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.SyncResourceStatus;
import software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncResourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyncResourceSummary> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(SyncResourceSummary.getter(SyncResourceSummary::resourceTypeAsString)).setter(SyncResourceSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(SyncResourceSummary.getter(SyncResourceSummary::externalId)).setter(SyncResourceSummary.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(SyncResourceSummary.getter(SyncResourceSummary::resourceId)).setter(SyncResourceSummary.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<SyncResourceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(SyncResourceSummary.getter(SyncResourceSummary::status)).setter(SyncResourceSummary.setter(Builder::status)).constructor(SyncResourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(SyncResourceSummary.getter(SyncResourceSummary::updateDateTime)).setter(SyncResourceSummary.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, EXTERNAL_ID_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD, UPDATE_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("externalId", EXTERNAL_ID_FIELD);
            this.put("resourceId", RESOURCE_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String externalId;
    private final String resourceId;
    private final SyncResourceStatus status;
    private final Instant updateDateTime;

    private SyncResourceSummary(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.externalId = builder.externalId;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.updateDateTime = builder.updateDateTime;
    }

    public final SyncResourceType resourceType() {
        return SyncResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final SyncResourceStatus status() {
        return this.status;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncResourceSummary)) {
            return false;
        }
        SyncResourceSummary other = (SyncResourceSummary)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.updateDateTime(), other.updateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"SyncResourceSummary").add("ResourceType", (Object)this.resourceTypeAsString()).add("ExternalId", (Object)this.externalId()).add("ResourceId", (Object)this.resourceId()).add("Status", (Object)this.status()).add("UpdateDateTime", (Object)this.updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SyncResourceSummary, T> g) {
        return obj -> g.apply((SyncResourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String externalId;
        private String resourceId;
        private SyncResourceStatus status;
        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncResourceSummary model) {
            this.resourceType(model.resourceType);
            this.externalId(model.externalId);
            this.resourceId(model.resourceId);
            this.status(model.status);
            this.updateDateTime(model.updateDateTime);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(SyncResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SyncResourceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SyncResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SyncResourceStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public SyncResourceSummary build() {
            return new SyncResourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyncResourceSummary> {
        public Builder resourceType(String var1);

        public Builder resourceType(SyncResourceType var1);

        public Builder externalId(String var1);

        public Builder resourceId(String var1);

        public Builder status(SyncResourceStatus var1);

        default public Builder status(Consumer<SyncResourceStatus.Builder> status) {
            return this.status((SyncResourceStatus)((SyncResourceStatus.Builder)SyncResourceStatus.builder().applyMutation(status)).build());
        }

        public Builder updateDateTime(Instant var1);
    }
}

