/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse;

public class ListAssetModelCompositeModelsIterable
implements SdkIterable<ListAssetModelCompositeModelsResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssetModelCompositeModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetModelCompositeModelsIterable(IoTSiteWiseClient client, ListAssetModelCompositeModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetModelCompositeModelsResponseFetcher();
    }

    public Iterator<ListAssetModelCompositeModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries() {
        Function<ListAssetModelCompositeModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetModelCompositeModelSummaries() != null) {
                return response.assetModelCompositeModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetModelCompositeModelsResponseFetcher
    implements SyncPageFetcher<ListAssetModelCompositeModelsResponse> {
        private ListAssetModelCompositeModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetModelCompositeModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetModelCompositeModelsResponse nextPage(ListAssetModelCompositeModelsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetModelCompositeModelsIterable.this.client.listAssetModelCompositeModels(ListAssetModelCompositeModelsIterable.this.firstRequest);
            }
            return ListAssetModelCompositeModelsIterable.this.client.listAssetModelCompositeModels((ListAssetModelCompositeModelsRequest)((Object)ListAssetModelCompositeModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

