/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.DatasetSource;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatasetRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdateDatasetRequest> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::datasetId)).setter(UpdateDatasetRequest.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetName").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::datasetName)).setter(UpdateDatasetRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()}).build();
    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetDescription").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::datasetDescription)).setter(UpdateDatasetRequest.setter(Builder::datasetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build()}).build();
    private static final SdkField<DatasetSource> DATASET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetSource").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::datasetSource)).setter(UpdateDatasetRequest.setter(Builder::datasetSource)).constructor(DatasetSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::clientToken)).setter(UpdateDatasetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, DATASET_NAME_FIELD, DATASET_DESCRIPTION_FIELD, DATASET_SOURCE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datasetId", DATASET_ID_FIELD);
            this.put("datasetName", DATASET_NAME_FIELD);
            this.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
            this.put("datasetSource", DATASET_SOURCE_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String datasetId;
    private final String datasetName;
    private final String datasetDescription;
    private final DatasetSource datasetSource;
    private final String clientToken;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetName = builder.datasetName;
        this.datasetDescription = builder.datasetDescription;
        this.datasetSource = builder.datasetSource;
        this.clientToken = builder.clientToken;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetDescription() {
        return this.datasetDescription;
    }

    public final DatasetSource datasetSource() {
        return this.datasetSource;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetDescription(), other.datasetDescription()) && Objects.equals(this.datasetSource(), other.datasetSource()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatasetRequest").add("DatasetId", (Object)this.datasetId()).add("DatasetName", (Object)this.datasetName()).add("DatasetDescription", (Object)this.datasetDescription()).add("DatasetSource", (Object)this.datasetSource()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "datasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "datasetDescription": {
                return Optional.ofNullable(clazz.cast(this.datasetDescription()));
            }
            case "datasetSource": {
                return Optional.ofNullable(clazz.cast(this.datasetSource()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String datasetId;
        private String datasetName;
        private String datasetDescription;
        private DatasetSource datasetSource;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            this.datasetId(model.datasetId);
            this.datasetName(model.datasetName);
            this.datasetDescription(model.datasetDescription);
            this.datasetSource(model.datasetSource);
            this.clientToken(model.clientToken);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetDescription() {
            return this.datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetSource.Builder getDatasetSource() {
            return this.datasetSource != null ? this.datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatasetRequest> {
        public Builder datasetId(String var1);

        public Builder datasetName(String var1);

        public Builder datasetDescription(String var1);

        public Builder datasetSource(DatasetSource var1);

        default public Builder datasetSource(Consumer<DatasetSource.Builder> datasetSource) {
            return this.datasetSource((DatasetSource)((DatasetSource.Builder)DatasetSource.builder().applyMutation(datasetSource)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

