/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedAssetsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListAssociatedAssetsResponse> {
    private static final SdkField<List<AssociatedAssetsSummary>> ASSET_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetSummaries").getter(ListAssociatedAssetsResponse.getter(ListAssociatedAssetsResponse::assetSummaries)).setter(ListAssociatedAssetsResponse.setter(Builder::assetSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedAssetsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedAssetsResponse.getter(ListAssociatedAssetsResponse::nextToken)).setter(ListAssociatedAssetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetSummaries", ASSET_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AssociatedAssetsSummary> assetSummaries;
    private final String nextToken;

    private ListAssociatedAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.assetSummaries = builder.assetSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssetSummaries() {
        return this.assetSummaries != null && !(this.assetSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssociatedAssetsSummary> assetSummaries() {
        return this.assetSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetSummaries() ? this.assetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedAssetsResponse)) {
            return false;
        }
        ListAssociatedAssetsResponse other = (ListAssociatedAssetsResponse)((Object)obj);
        return this.hasAssetSummaries() == other.hasAssetSummaries() && Objects.equals(this.assetSummaries(), other.assetSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedAssetsResponse").add("AssetSummaries", this.hasAssetSummaries() ? this.assetSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetSummaries": {
                return Optional.ofNullable(clazz.cast(this.assetSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedAssetsResponse, T> g) {
        return obj -> g.apply((ListAssociatedAssetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<AssociatedAssetsSummary> assetSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedAssetsResponse model) {
            super(model);
            this.assetSummaries(model.assetSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AssociatedAssetsSummary.Builder> getAssetSummaries() {
            List<AssociatedAssetsSummary.Builder> result = AssociatedAssetsSummariesCopier.copyToBuilder(this.assetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetSummaries(Collection<AssociatedAssetsSummary.BuilderImpl> assetSummaries) {
            this.assetSummaries = AssociatedAssetsSummariesCopier.copyFromBuilder(assetSummaries);
        }

        @Override
        public final Builder assetSummaries(Collection<AssociatedAssetsSummary> assetSummaries) {
            this.assetSummaries = AssociatedAssetsSummariesCopier.copy(assetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSummaries(AssociatedAssetsSummary ... assetSummaries) {
            this.assetSummaries(Arrays.asList(assetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSummaries(Consumer<AssociatedAssetsSummary.Builder> ... assetSummaries) {
            this.assetSummaries(Stream.of(assetSummaries).map(c -> (AssociatedAssetsSummary)((AssociatedAssetsSummary.Builder)AssociatedAssetsSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedAssetsResponse build() {
            return new ListAssociatedAssetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedAssetsResponse> {
        public Builder assetSummaries(Collection<AssociatedAssetsSummary> var1);

        public Builder assetSummaries(AssociatedAssetsSummary ... var1);

        public Builder assetSummaries(Consumer<AssociatedAssetsSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

