/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.Csv;
import software.amazon.awssdk.services.iotsitewise.model.Parquet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileFormat> {
    private static final SdkField<Csv> CSV_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("csv").getter(FileFormat.getter(FileFormat::csv)).setter(FileFormat.setter(Builder::csv)).constructor(Csv::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csv").build()}).build();
    private static final SdkField<Parquet> PARQUET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parquet").getter(FileFormat.getter(FileFormat::parquet)).setter(FileFormat.setter(Builder::parquet)).constructor(Parquet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FIELD, PARQUET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("csv", CSV_FIELD);
            this.put("parquet", PARQUET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Csv csv;
    private final Parquet parquet;

    private FileFormat(BuilderImpl builder) {
        this.csv = builder.csv;
        this.parquet = builder.parquet;
    }

    public final Csv csv() {
        return this.csv;
    }

    public final Parquet parquet() {
        return this.parquet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.csv());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileFormat)) {
            return false;
        }
        FileFormat other = (FileFormat)obj;
        return Objects.equals(this.csv(), other.csv()) && Objects.equals(this.parquet(), other.parquet());
    }

    public final String toString() {
        return ToString.builder((String)"FileFormat").add("Csv", (Object)this.csv()).add("Parquet", (Object)this.parquet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "csv": {
                return Optional.ofNullable(clazz.cast(this.csv()));
            }
            case "parquet": {
                return Optional.ofNullable(clazz.cast(this.parquet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileFormat, T> g) {
        return obj -> g.apply((FileFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Csv csv;
        private Parquet parquet;

        private BuilderImpl() {
        }

        private BuilderImpl(FileFormat model) {
            this.csv(model.csv);
            this.parquet(model.parquet);
        }

        public final Csv.Builder getCsv() {
            return this.csv != null ? this.csv.toBuilder() : null;
        }

        public final void setCsv(Csv.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public final Builder csv(Csv csv) {
            this.csv = csv;
            return this;
        }

        public final Parquet.Builder getParquet() {
            return this.parquet != null ? this.parquet.toBuilder() : null;
        }

        public final void setParquet(Parquet.BuilderImpl parquet) {
            this.parquet = parquet != null ? parquet.build() : null;
        }

        @Override
        public final Builder parquet(Parquet parquet) {
            this.parquet = parquet;
            return this;
        }

        public FileFormat build() {
            return new FileFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileFormat> {
        public Builder csv(Csv var1);

        default public Builder csv(Consumer<Csv.Builder> csv) {
            return this.csv((Csv)((Csv.Builder)Csv.builder().applyMutation(csv)).build());
        }

        public Builder parquet(Parquet var1);

        default public Builder parquet(Consumer<Parquet.Builder> parquet) {
            return this.parquet((Parquet)((Parquet.Builder)Parquet.builder().applyMutation(parquet)).build());
        }
    }
}

