/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AggregateType;
import software.amazon.awssdk.services.iotsitewise.model.AggregateTypesCopier;
import software.amazon.awssdk.services.iotsitewise.model.QualitiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.services.iotsitewise.model.TimeOrdering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyAggregatesEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetAssetPropertyAggregatesEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::entryId)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::assetId)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::propertyId)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::propertyAlias)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()}).build();
    private static final SdkField<List<String>> AGGREGATE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregateTypes").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::aggregateTypesAsStrings)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::aggregateTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolution").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::resolution)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::startDate)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDate").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::endDate)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build()}).build();
    private static final SdkField<List<String>> QUALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("qualities").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::qualitiesAsStrings)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::qualitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_ORDERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeOrdering").getter(BatchGetAssetPropertyAggregatesEntry.getter(BatchGetAssetPropertyAggregatesEntry::timeOrderingAsString)).setter(BatchGetAssetPropertyAggregatesEntry.setter(Builder::timeOrdering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOrdering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, AGGREGATE_TYPES_FIELD, RESOLUTION_FIELD, START_DATE_FIELD, END_DATE_FIELD, QUALITIES_FIELD, TIME_ORDERING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("entryId", ENTRY_ID_FIELD);
            this.put("assetId", ASSET_ID_FIELD);
            this.put("propertyId", PROPERTY_ID_FIELD);
            this.put("propertyAlias", PROPERTY_ALIAS_FIELD);
            this.put("aggregateTypes", AGGREGATE_TYPES_FIELD);
            this.put("resolution", RESOLUTION_FIELD);
            this.put("startDate", START_DATE_FIELD);
            this.put("endDate", END_DATE_FIELD);
            this.put("qualities", QUALITIES_FIELD);
            this.put("timeOrdering", TIME_ORDERING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final List<String> aggregateTypes;
    private final String resolution;
    private final Instant startDate;
    private final Instant endDate;
    private final List<String> qualities;
    private final String timeOrdering;

    private BatchGetAssetPropertyAggregatesEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.aggregateTypes = builder.aggregateTypes;
        this.resolution = builder.resolution;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.qualities = builder.qualities;
        this.timeOrdering = builder.timeOrdering;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String propertyAlias() {
        return this.propertyAlias;
    }

    public final List<AggregateType> aggregateTypes() {
        return AggregateTypesCopier.copyStringToEnum(this.aggregateTypes);
    }

    public final boolean hasAggregateTypes() {
        return this.aggregateTypes != null && !(this.aggregateTypes instanceof SdkAutoConstructList);
    }

    public final List<String> aggregateTypesAsStrings() {
        return this.aggregateTypes;
    }

    public final String resolution() {
        return this.resolution;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final List<Quality> qualities() {
        return QualitiesCopier.copyStringToEnum(this.qualities);
    }

    public final boolean hasQualities() {
        return this.qualities != null && !(this.qualities instanceof SdkAutoConstructList);
    }

    public final List<String> qualitiesAsStrings() {
        return this.qualities;
    }

    public final TimeOrdering timeOrdering() {
        return TimeOrdering.fromValue(this.timeOrdering);
    }

    public final String timeOrderingAsString() {
        return this.timeOrdering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregateTypes() ? this.aggregateTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualities() ? this.qualitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOrderingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesEntry)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesEntry other = (BatchGetAssetPropertyAggregatesEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && this.hasAggregateTypes() == other.hasAggregateTypes() && Objects.equals(this.aggregateTypesAsStrings(), other.aggregateTypesAsStrings()) && Objects.equals(this.resolution(), other.resolution()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && this.hasQualities() == other.hasQualities() && Objects.equals(this.qualitiesAsStrings(), other.qualitiesAsStrings()) && Objects.equals(this.timeOrderingAsString(), other.timeOrderingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyAggregatesEntry").add("EntryId", (Object)this.entryId()).add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("AggregateTypes", this.hasAggregateTypes() ? this.aggregateTypesAsStrings() : null).add("Resolution", (Object)this.resolution()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Qualities", this.hasQualities() ? this.qualitiesAsStrings() : null).add("TimeOrdering", (Object)this.timeOrderingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "aggregateTypes": {
                return Optional.ofNullable(clazz.cast(this.aggregateTypesAsStrings()));
            }
            case "resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "qualities": {
                return Optional.ofNullable(clazz.cast(this.qualitiesAsStrings()));
            }
            case "timeOrdering": {
                return Optional.ofNullable(clazz.cast(this.timeOrderingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private List<String> aggregateTypes = DefaultSdkAutoConstructList.getInstance();
        private String resolution;
        private Instant startDate;
        private Instant endDate;
        private List<String> qualities = DefaultSdkAutoConstructList.getInstance();
        private String timeOrdering;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesEntry model) {
            this.entryId(model.entryId);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.aggregateTypesWithStrings(model.aggregateTypes);
            this.resolution(model.resolution);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.qualitiesWithStrings(model.qualities);
            this.timeOrdering(model.timeOrdering);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final Collection<String> getAggregateTypes() {
            if (this.aggregateTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregateTypes;
        }

        public final void setAggregateTypes(Collection<String> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copy(aggregateTypes);
        }

        @Override
        public final Builder aggregateTypesWithStrings(Collection<String> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copy(aggregateTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateTypesWithStrings(String ... aggregateTypes) {
            this.aggregateTypesWithStrings(Arrays.asList(aggregateTypes));
            return this;
        }

        @Override
        public final Builder aggregateTypes(Collection<AggregateType> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copyEnumToString(aggregateTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateTypes(AggregateType ... aggregateTypes) {
            this.aggregateTypes(Arrays.asList(aggregateTypes));
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Collection<String> getQualities() {
            if (this.qualities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.qualities;
        }

        public final void setQualities(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
        }

        @Override
        public final Builder qualitiesWithStrings(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualitiesWithStrings(String ... qualities) {
            this.qualitiesWithStrings(Arrays.asList(qualities));
            return this;
        }

        @Override
        public final Builder qualities(Collection<Quality> qualities) {
            this.qualities = QualitiesCopier.copyEnumToString(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualities(Quality ... qualities) {
            this.qualities(Arrays.asList(qualities));
            return this;
        }

        public final String getTimeOrdering() {
            return this.timeOrdering;
        }

        public final void setTimeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
        }

        @Override
        public final Builder timeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
            return this;
        }

        @Override
        public final Builder timeOrdering(TimeOrdering timeOrdering) {
            this.timeOrdering(timeOrdering == null ? null : timeOrdering.toString());
            return this;
        }

        public BatchGetAssetPropertyAggregatesEntry build() {
            return new BatchGetAssetPropertyAggregatesEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesEntry> {
        public Builder entryId(String var1);

        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder aggregateTypesWithStrings(Collection<String> var1);

        public Builder aggregateTypesWithStrings(String ... var1);

        public Builder aggregateTypes(Collection<AggregateType> var1);

        public Builder aggregateTypes(AggregateType ... var1);

        public Builder resolution(String var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder qualitiesWithStrings(Collection<String> var1);

        public Builder qualitiesWithStrings(String ... var1);

        public Builder qualities(Collection<Quality> var1);

        public Builder qualities(Quality ... var1);

        public Builder timeOrdering(String var1);

        public Builder timeOrdering(TimeOrdering var1);
    }
}

