/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.DataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCampaignRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, UpdateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::name)).setter(UpdateCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::description)).setter(UpdateCampaignRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataExtraDimensions").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::dataExtraDimensions)).setter(UpdateCampaignRequest.setter(Builder::dataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::actionAsString)).setter(UpdateCampaignRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
            this.put("action", ACTION_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final List<String> dataExtraDimensions;
    private final String action;

    private UpdateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.action = builder.action;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDataExtraDimensions() {
        return this.dataExtraDimensions != null && !(this.dataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> dataExtraDimensions() {
        return this.dataExtraDimensions;
    }

    public final UpdateCampaignAction action() {
        return UpdateCampaignAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignRequest)) {
            return false;
        }
        UpdateCampaignRequest other = (UpdateCampaignRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasDataExtraDimensions() == other.hasDataExtraDimensions() && Objects.equals(this.dataExtraDimensions(), other.dataExtraDimensions()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCampaignRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DataExtraDimensions", (Object)(this.dataExtraDimensions() == null ? null : "*** Sensitive Data Redacted ***")).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.dataExtraDimensions()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignRequest, T> g) {
        return obj -> g.apply((UpdateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.dataExtraDimensions(model.dataExtraDimensions);
            this.action(model.action);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (this.dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = DataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String ... dataExtraDimensions) {
            this.dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateCampaignAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignRequest build() {
            return new UpdateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCampaignRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dataExtraDimensions(Collection<String> var1);

        public Builder dataExtraDimensions(String ... var1);

        public Builder action(String var1);

        public Builder action(UpdateCampaignAction var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

