/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerManagedDatastoreS3StorageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerManagedDatastoreS3StorageSummary> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(CustomerManagedDatastoreS3StorageSummary.getter(CustomerManagedDatastoreS3StorageSummary::bucket)).setter(CustomerManagedDatastoreS3StorageSummary.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPrefix").getter(CustomerManagedDatastoreS3StorageSummary.getter(CustomerManagedDatastoreS3StorageSummary::keyPrefix)).setter(CustomerManagedDatastoreS3StorageSummary.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CustomerManagedDatastoreS3StorageSummary.getter(CustomerManagedDatastoreS3StorageSummary::roleArn)).setter(CustomerManagedDatastoreS3StorageSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_PREFIX_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bucket", BUCKET_FIELD);
            this.put("keyPrefix", KEY_PREFIX_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String keyPrefix;
    private final String roleArn;

    private CustomerManagedDatastoreS3StorageSummary(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.roleArn = builder.roleArn;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String keyPrefix() {
        return this.keyPrefix;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedDatastoreS3StorageSummary)) {
            return false;
        }
        CustomerManagedDatastoreS3StorageSummary other = (CustomerManagedDatastoreS3StorageSummary)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.keyPrefix(), other.keyPrefix()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerManagedDatastoreS3StorageSummary").add("Bucket", (Object)this.bucket()).add("KeyPrefix", (Object)this.keyPrefix()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedDatastoreS3StorageSummary, T> g) {
        return obj -> g.apply((CustomerManagedDatastoreS3StorageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String keyPrefix;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedDatastoreS3StorageSummary model) {
            this.bucket(model.bucket);
            this.keyPrefix(model.keyPrefix);
            this.roleArn(model.roleArn);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public CustomerManagedDatastoreS3StorageSummary build() {
            return new CustomerManagedDatastoreS3StorageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerManagedDatastoreS3StorageSummary> {
        public Builder bucket(String var1);

        public Builder keyPrefix(String var1);

        public Builder roleArn(String var1);
    }
}

