/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PackageVersionArtifact;
import software.amazon.awssdk.services.iot.model.PackageVersionStatus;
import software.amazon.awssdk.services.iot.model.ResourceAttributesCopier;
import software.amazon.awssdk.services.iot.model.Sbom;
import software.amazon.awssdk.services.iot.model.SbomValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPackageVersionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetPackageVersionResponse> {
    private static final SdkField<String> PACKAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageVersionArn").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::packageVersionArn)).setter(GetPackageVersionResponse.setter(Builder::packageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVersionArn").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::packageName)).setter(GetPackageVersionResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::versionName)).setter(GetPackageVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::description)).setter(GetPackageVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::attributes)).setter(GetPackageVersionResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PackageVersionArtifact> ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifact").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::artifact)).setter(GetPackageVersionResponse.setter(Builder::artifact)).constructor(PackageVersionArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifact").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::statusAsString)).setter(GetPackageVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorReason").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::errorReason)).setter(GetPackageVersionResponse.setter(Builder::errorReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReason").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::creationDate)).setter(GetPackageVersionResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::lastModifiedDate)).setter(GetPackageVersionResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Sbom> SBOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sbom").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::sbom)).setter(GetPackageVersionResponse.setter(Builder::sbom)).constructor(Sbom::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()}).build();
    private static final SdkField<String> SBOM_VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sbomValidationStatus").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::sbomValidationStatusAsString)).setter(GetPackageVersionResponse.setter(Builder::sbomValidationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbomValidationStatus").build()}).build();
    private static final SdkField<String> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipe").getter(GetPackageVersionResponse.getter(GetPackageVersionResponse::recipe)).setter(GetPackageVersionResponse.setter(Builder::recipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_ARN_FIELD, PACKAGE_NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTES_FIELD, ARTIFACT_FIELD, STATUS_FIELD, ERROR_REASON_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, SBOM_FIELD, SBOM_VALIDATION_STATUS_FIELD, RECIPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("packageVersionArn", PACKAGE_VERSION_ARN_FIELD);
            this.put("packageName", PACKAGE_NAME_FIELD);
            this.put("versionName", VERSION_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("artifact", ARTIFACT_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("errorReason", ERROR_REASON_FIELD);
            this.put("creationDate", CREATION_DATE_FIELD);
            this.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("sbom", SBOM_FIELD);
            this.put("sbomValidationStatus", SBOM_VALIDATION_STATUS_FIELD);
            this.put("recipe", RECIPE_FIELD);
        }
    });
    private final String packageVersionArn;
    private final String packageName;
    private final String versionName;
    private final String description;
    private final Map<String, String> attributes;
    private final PackageVersionArtifact artifact;
    private final String status;
    private final String errorReason;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final Sbom sbom;
    private final String sbomValidationStatus;
    private final String recipe;

    private GetPackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageVersionArn = builder.packageVersionArn;
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.attributes = builder.attributes;
        this.artifact = builder.artifact;
        this.status = builder.status;
        this.errorReason = builder.errorReason;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.sbom = builder.sbom;
        this.sbomValidationStatus = builder.sbomValidationStatus;
        this.recipe = builder.recipe;
    }

    public final String packageVersionArn() {
        return this.packageVersionArn;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final PackageVersionArtifact artifact() {
        return this.artifact;
    }

    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorReason() {
        return this.errorReason;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Sbom sbom() {
        return this.sbom;
    }

    public final SbomValidationStatus sbomValidationStatus() {
        return SbomValidationStatus.fromValue(this.sbomValidationStatus);
    }

    public final String sbomValidationStatusAsString() {
        return this.sbomValidationStatus;
    }

    public final String recipe() {
        return this.recipe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sbom());
        hashCode = 31 * hashCode + Objects.hashCode(this.sbomValidationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionResponse)) {
            return false;
        }
        GetPackageVersionResponse other = (GetPackageVersionResponse)((Object)obj);
        return Objects.equals(this.packageVersionArn(), other.packageVersionArn()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.description(), other.description()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.artifact(), other.artifact()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorReason(), other.errorReason()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.sbom(), other.sbom()) && Objects.equals(this.sbomValidationStatusAsString(), other.sbomValidationStatusAsString()) && Objects.equals(this.recipe(), other.recipe());
    }

    public final String toString() {
        return ToString.builder((String)"GetPackageVersionResponse").add("PackageVersionArn", (Object)this.packageVersionArn()).add("PackageName", (Object)this.packageName()).add("VersionName", (Object)this.versionName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).add("Artifact", (Object)this.artifact()).add("Status", (Object)this.statusAsString()).add("ErrorReason", (Object)this.errorReason()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Sbom", (Object)this.sbom()).add("SbomValidationStatus", (Object)this.sbomValidationStatusAsString()).add("Recipe", (Object)(this.recipe() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.packageVersionArn()));
            }
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "artifact": {
                return Optional.ofNullable(clazz.cast(this.artifact()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorReason": {
                return Optional.ofNullable(clazz.cast(this.errorReason()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "sbom": {
                return Optional.ofNullable(clazz.cast(this.sbom()));
            }
            case "sbomValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.sbomValidationStatusAsString()));
            }
            case "recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionResponse, T> g) {
        return obj -> g.apply((GetPackageVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String packageVersionArn;
        private String packageName;
        private String versionName;
        private String description;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private PackageVersionArtifact artifact;
        private String status;
        private String errorReason;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private Sbom sbom;
        private String sbomValidationStatus;
        private String recipe;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionResponse model) {
            super(model);
            this.packageVersionArn(model.packageVersionArn);
            this.packageName(model.packageName);
            this.versionName(model.versionName);
            this.description(model.description);
            this.attributes(model.attributes);
            this.artifact(model.artifact);
            this.status(model.status);
            this.errorReason(model.errorReason);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.sbom(model.sbom);
            this.sbomValidationStatus(model.sbomValidationStatus);
            this.recipe(model.recipe);
        }

        public final String getPackageVersionArn() {
            return this.packageVersionArn;
        }

        public final void setPackageVersionArn(String packageVersionArn) {
            this.packageVersionArn = packageVersionArn;
        }

        @Override
        public final Builder packageVersionArn(String packageVersionArn) {
            this.packageVersionArn = packageVersionArn;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ResourceAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ResourceAttributesCopier.copy(attributes);
            return this;
        }

        public final PackageVersionArtifact.Builder getArtifact() {
            return this.artifact != null ? this.artifact.toBuilder() : null;
        }

        public final void setArtifact(PackageVersionArtifact.BuilderImpl artifact) {
            this.artifact = artifact != null ? artifact.build() : null;
        }

        @Override
        public final Builder artifact(PackageVersionArtifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorReason() {
            return this.errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Sbom.Builder getSbom() {
            return this.sbom != null ? this.sbom.toBuilder() : null;
        }

        public final void setSbom(Sbom.BuilderImpl sbom) {
            this.sbom = sbom != null ? sbom.build() : null;
        }

        @Override
        public final Builder sbom(Sbom sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getSbomValidationStatus() {
            return this.sbomValidationStatus;
        }

        public final void setSbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
        }

        @Override
        public final Builder sbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
            return this;
        }

        @Override
        public final Builder sbomValidationStatus(SbomValidationStatus sbomValidationStatus) {
            this.sbomValidationStatus(sbomValidationStatus == null ? null : sbomValidationStatus.toString());
            return this;
        }

        public final String getRecipe() {
            return this.recipe;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        @Override
        public GetPackageVersionResponse build() {
            return new GetPackageVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPackageVersionResponse> {
        public Builder packageVersionArn(String var1);

        public Builder packageName(String var1);

        public Builder versionName(String var1);

        public Builder description(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder artifact(PackageVersionArtifact var1);

        default public Builder artifact(Consumer<PackageVersionArtifact.Builder> artifact) {
            return this.artifact((PackageVersionArtifact)((PackageVersionArtifact.Builder)PackageVersionArtifact.builder().applyMutation(artifact)).build());
        }

        public Builder status(String var1);

        public Builder status(PackageVersionStatus var1);

        public Builder errorReason(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder sbom(Sbom var1);

        default public Builder sbom(Consumer<Sbom.Builder> sbom) {
            return this.sbom((Sbom)((Sbom.Builder)Sbom.builder().applyMutation(sbom)).build());
        }

        public Builder sbomValidationStatus(String var1);

        public Builder sbomValidationStatus(SbomValidationStatus var1);

        public Builder recipe(String var1);
    }
}

