/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Operator {
    EQUALS("EQUALS"),
    NOT_EQUALS("NOT_EQUALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Operator> VALUE_MAP;
    private final String value;

    private Operator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Operator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Operator> knownValues() {
        EnumSet<Operator> knownValues = EnumSet.allOf(Operator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Operator.class, Operator::toString);
    }
}

