/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.CisScanConfiguration;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCisScanConfigurationsResponse;

public class ListCisScanConfigurationsPublisher
implements SdkPublisher<ListCisScanConfigurationsResponse> {
    private final Inspector2AsyncClient client;
    private final ListCisScanConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCisScanConfigurationsPublisher(Inspector2AsyncClient client, ListCisScanConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCisScanConfigurationsPublisher(Inspector2AsyncClient client, ListCisScanConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCisScanConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCisScanConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CisScanConfiguration> scanConfigurations() {
        Function<ListCisScanConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanConfigurations() != null) {
                return response.scanConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCisScanConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCisScanConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListCisScanConfigurationsResponse> {
        private ListCisScanConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCisScanConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCisScanConfigurationsResponse> nextPage(ListCisScanConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListCisScanConfigurationsPublisher.this.client.listCisScanConfigurations(ListCisScanConfigurationsPublisher.this.firstRequest);
            }
            return ListCisScanConfigurationsPublisher.this.client.listCisScanConfigurations((ListCisScanConfigurationsRequest)((Object)ListCisScanConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

