/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Ec2ScanMode {
    EC2_SSM_AGENT_BASED("EC2_SSM_AGENT_BASED"),
    EC2_HYBRID("EC2_HYBRID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ec2ScanMode> VALUE_MAP;
    private final String value;

    private Ec2ScanMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Ec2ScanMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Ec2ScanMode> knownValues() {
        EnumSet<Ec2ScanMode> knownValues = EnumSet.allOf(Ec2ScanMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Ec2ScanMode.class, Ec2ScanMode::toString);
    }
}

