/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CisSecurityLevel {
    LEVEL_1("LEVEL_1"),
    LEVEL_2("LEVEL_2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CisSecurityLevel> VALUE_MAP;
    private final String value;

    private CisSecurityLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CisSecurityLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CisSecurityLevel> knownValues() {
        EnumSet<CisSecurityLevel> knownValues = EnumSet.allOf(CisSecurityLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CisSecurityLevel.class, CisSecurityLevel::toString);
    }
}

